<?php
// Include the database configuration file
include 'config.php';

// Check if item_name and quantity are set in the POST request
if (isset($_POST['item_name']) && isset($_POST['quantity'])) {
    $item_name = $_POST['item_name'];
    $quantity = $_POST['quantity'];

    // === Update in `cart` table ===
    $stmt = $conn->prepare("UPDATE cart SET quantity = ? WHERE item_name = ?");
    $stmt->bind_param("is", $quantity, $item_name);
    $stmt->execute();
    $stmt->close();

    $stmt = $conn->prepare("UPDATE cart SET subtotal = (item_price * quantity) WHERE item_name = ?");
    $stmt->bind_param("s", $item_name);
    $stmt->execute();
    $stmt->close();

    // === Update in `cart2` table ===
    $stmt = $conn->prepare("UPDATE cart2 SET quantity = ? WHERE item_name = ?");
    $stmt->bind_param("is", $quantity, $item_name);
    $stmt->execute();
    $stmt->close();

    $stmt = $conn->prepare("UPDATE cart2 SET subtotal = (item_price * quantity) WHERE item_name = ?");
    $stmt->bind_param("s", $item_name);
    $stmt->execute();
    $stmt->close();

    echo "Quantity and subtotal updated successfully in both tables.";
} else {
    echo "Invalid request.";
}

// Close the database connection
$conn->close();
?>
