<?php
session_start();

// Include the database configuration file
include 'config.php';

// Check if the user is logged in and user_id is available in the session
if (isset($_SESSION['user_id'])) {
    $user_id = $_SESSION['user_id'];

    // Introduce a delay of 5 seconds
    sleep(5);

     //Clear the cart for the current session in the database
    $sql_clear_cart = "DELETE FROM cart WHERE user_id = ?";
    $stmt_clear_cart = $conn->prepare($sql_clear_cart);
    $stmt_clear_cart->bind_param("i", $user_id);
    $stmt_clear_cart->execute();

    // Delete all records from user_info2 table for the current user
    $sql_clear_user_info = "DELETE FROM user_info2 WHERE user_id = ?";
    $stmt_clear_user_info = $conn->prepare($sql_clear_user_info);
    $stmt_clear_user_info->bind_param("i", $user_id);
    $stmt_clear_user_info->execute();

    // Update order_status to 'done' in payment_method table for the current user
    $sql_update_order_status = "UPDATE payment_method SET order_status = 'done' WHERE user_id = ?";
    $stmt_update_order_status = $conn->prepare($sql_update_order_status);
    $stmt_update_order_status->bind_param("i", $user_id);
    $stmt_update_order_status->execute();

    // Update menu_status to 'order place' in cart2 table for the current user
    $sql_update_menu_status = "UPDATE cart2 SET menu_status = 'order place' WHERE user_id = ?";
    $stmt_update_menu_status = $conn->prepare($sql_update_menu_status);
    $stmt_update_menu_status->bind_param("i", $user_id);
    $stmt_update_menu_status->execute();

    echo "Cart cleared successfully, user info deleted, order marked as done, and menu status updated in cart2.";
} else {
    echo "User ID not found in session. Cart not cleared.";
}

// Close the database connection
$conn->close();
?>
