<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Order Receipt</title>
    <style>
        /* Resetting default browser styles */
        body, table {
            margin: 0;
            padding: 0;
            font-family: Arial, sans-serif;
        }

        /* Styling the receipt table */
        .receipt-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        .receipt-table th, .receipt-table td {
            border: none;
            padding: 8px;
            text-align: left;
        }

        .receipt-table th {
            background-color: #f2f2f2;
        }

        /* Styling for empty cart message */
        .empty-cart-message {
            margin-bottom: 20px;
            font-style: italic;
            color: #666;
        }

    /* Styling for the button */
.done-button {
    background-color: rgb(110, 59, 39);
    border: none;
    color: white;
    padding: 10px 10px;
    text-align: center;
    text-decoration: none;
    display: block; /* Make it a block element for full width */
    width: 100%; /* Full width */
    font-size: 14px;
    margin-top: 20px;
    cursor: pointer;
    border-radius: 5px;
}


        /* Styling for the receipt container */
        .receipt-container {
            max-width: 600px;
            margin: 20px auto;
            padding: 20px;
            border: 1px solid #ccc;
            border-radius: 10px;
        }

        /* Styling for the receipt header */
        .receipt-header {
            text-align: center;
            margin-bottom: 20px;
        }

        /* Styling for user information */
        .user-info {
            margin-bottom: 20px;
        }

        /* Styling for the total section */
        .total-section {
            margin-top: 20px;
            text-align: right;
        }

        .spinner {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    border: 4px solid rgba(0, 0, 0, 0.1);
    border-top-color: #007bff;
    animation: spin 1s linear infinite;
}

@keyframes spin {
    to {
        transform: rotate(360deg);
    }
}

    </style>
</head>
<body>
    <div class="receipt-container">
        <div class="receipt-header">
        <img src="Logo N.A.png" alt="logo" style="width: 100px;">

        <br></br>
            <h2>Bill order</h2>
        </div>


<?php
// Start the session
session_start();

// Include the database configuration file
include 'config.php';

// Check if the user is logged in and user_id is available in the session
if (isset($_SESSION['user_id'])) {
    $user_id = $_SESSION['user_id'];

    // ✅ Retrieve user information
    $sql_user = "SELECT name, phone, created_at FROM user_info WHERE user_id = ?";
    $stmt_user = $conn->prepare($sql_user);
    $stmt_user->bind_param("i", $user_id);
    $stmt_user->execute();
    $result_user = $stmt_user->get_result();

    if ($result_user->num_rows > 0) {
        $user_info = $result_user->fetch_assoc();
        echo '<div class="user-info">';
        echo '<p><strong>User Name:</strong> ' . $user_info['name'] . '</p>';
        echo '<p><strong>Phone:</strong> ' . $user_info['phone'] . '</p>';
        echo '<p><strong>Date Registered:</strong> ' . $user_info['created_at'] . '</p>';
        echo '</div>';
    }

    // ✅ Get latest order_number from cart2
    $sql_latest_order = "SELECT order_number FROM cart2 WHERE user_id = ? ORDER BY id DESC LIMIT 1";
    $stmt_latest_order = $conn->prepare($sql_latest_order);
    $stmt_latest_order->bind_param("i", $user_id);
    $stmt_latest_order->execute();
    $result_latest_order = $stmt_latest_order->get_result();

    if ($result_latest_order->num_rows > 0) {
        $latest_order = $result_latest_order->fetch_assoc();
        $order_number = $latest_order['order_number'];

        echo '<p><strong>Order Number:</strong> ' . $order_number . '</p>';

        // ✅ Get payment option from payment_method
        $sql_payment = "SELECT payment_option FROM payment_method WHERE user_id = ? AND order_number = ?";
        $stmt_payment = $conn->prepare($sql_payment);
        $stmt_payment->bind_param("ii", $user_id, $order_number);
        $stmt_payment->execute();
        $result_payment = $stmt_payment->get_result();

        if ($result_payment->num_rows > 0) {
            $payment_data = $result_payment->fetch_assoc();
            echo '<p><strong>Payment Method:</strong> ' . $payment_data['payment_option'] . '</p>';
        }

        echo '<hr>';
$sql_cart = "SELECT item_name, created_at, item_price, quantity, item_price * quantity AS subtotal 
                 FROM cart2 
                 WHERE user_id = ? AND order_number = ?";


    $stmt_cart = $conn->prepare($sql_cart);
    $stmt_cart->bind_param("is", $user_id, $order_number);
    $stmt_cart->execute();
    $result_cart = $stmt_cart->get_result();

       if ($result_cart->num_rows > 0) {
        echo '<table class="receipt-table">';
        echo '<thead><tr><th>Item Name</th><th>Price</th><th>Quantity</th><th>Subtotal</th></tr></thead><tbody>';

        $total = 0;

        while ($row = $result_cart->fetch_assoc()) {
            echo '<tr>';
            echo '<td>' . $row['item_name'] . '</td>';
            echo '<td>RM' . number_format($row['item_price'], 2) . '</td>';
            echo '<td>' . $row['quantity'] . '</td>';
            echo '<td>RM' . number_format($row['subtotal'], 2) . '</td>';
            echo '</tr>';

            $total += $row['subtotal'];
        }
            echo '</tbody></table>';

            // ✅ Total amount section
            echo '<div class="total-section">';
            echo '<p><strong>Total Amount:</strong> RM' . number_format($total, 2) . '</p>';
            echo '</div>';
        } else {
            echo "<p class='empty-cart-message'>No items found for this order.</p>";
        }

        $stmt_cart->close();
    } else {
        echo "<p class='empty-cart-message'>No order found for this user.</p>";
    }

} else {
    echo '<p class="empty-cart-message">User is not logged in. Please log in to continue.</p>';
}

// Close the database connection
$conn->close();
?>



<form id="clear-cart-form">
    <!--<button type="button" class="done-button" onclick="clearCart()">Done</button>!-->
<a href="javascript:void(0);" class="done-button" onclick="showContent('home')">back to home</a>

    <p>your order are directly send to seller, please wait for prepairing </p>
</form>


<div id="loading-spinner" style="display: none;">
    <!-- Circle spinner HTML -->
    <div class="spinner"></div>
</div>
<div id="result-message"></div>


<script>
    function clearCart() {
        // Show the loading spinner
        document.getElementById("loading-spinner").style.display = "block";

        // Create a new XMLHttpRequest object
        var xhr = new XMLHttpRequest();

        // Prepare the request
        xhr.open("POST", "reset_session.php", true);
        
        // Set up the onload function to handle the response
        xhr.onload = function() {
            // Hide the loading spinner
            document.getElementById("loading-spinner").style.display = "none";

            // Check if the request was successful
            if (xhr.status === 200) {
                // Display the response message
                document.getElementById("result-message").innerText = xhr.responseText;
            } else {
                // Display an error message
                document.getElementById("result-message").innerText = 'Error: Unable to clear cart. Please try again.';
            }
        };

        // Send the request
        xhr.send();
    }
</script>


        
    </div>
</body>
</html>
