<?php
// Start the session
session_start();

// Include the database configuration file
include 'config.php';

// Check if the payment method form is submitted
if(isset($_POST['paymentMethod'])) {
    // Get user_id from the session
    if(isset($_SESSION['user_id'])) {
        $user_id = $_SESSION['user_id'];

        // Get the selected payment method
        $paymentMethod = $_POST['paymentMethod'];

        // Insert the payment method and user ID into the database
        $sql_payment = "INSERT INTO payment_method (user_id, method, done) VALUES (?, ?, 1) ON DUPLICATE KEY UPDATE done = 1";
        $stmt_payment = $conn->prepare($sql_payment);
        $stmt_payment->bind_param("is", $user_id, $paymentMethod);

        // Execute the query
        if ($stmt_payment->execute()) {
            // Payment method saved successfully
            $message = "Payment method saved: $paymentMethod";

            // Update cart2 to mark payment as done
            $sql_update_cart2 = "UPDATE cart2 SET payment = 'payment done' WHERE user_id = ?";
            $stmt_update_cart2 = $conn->prepare($sql_update_cart2);
            $stmt_update_cart2->bind_param("i", $user_id);
            $stmt_update_cart2->execute();
            $stmt_update_cart2->close();
        } else {
            // Error saving payment method
            $message = "Error saving payment method.";
        }

        // Retrieve cart items for the user from the database
        $sql_cart = "SELECT item_name, item_price, quantity, item_price * quantity AS subtotal FROM cart WHERE user_id = ?";
        $stmt_cart = $conn->prepare($sql_cart);
        $stmt_cart->bind_param("i", $user_id);
        $stmt_cart->execute();
        $result_cart = $stmt_cart->get_result();
        $stmt_cart->close();
    } else {
        // User is not logged in or user_id is not available in session
        $message = 'User ID is not available or user is not logged in.';
    }
} else {
    // Payment method form is not submitted
    $message = 'Payment method form is not submitted.';
}

// Close the database connection
$conn->close();
?>

<!DOCTYPE html>
<html>
<head>
    <title>Payment Receipt</title>
    <!-- Include CSS styles here -->
    <style>
        /* Add your CSS styles here */
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background-color: #f9f9f9;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        h1 {
            text-align: center;
            margin-bottom: 30px;
        }
        .message {
            text-align: center;
            margin-bottom: 20px;
        }
        .receipt-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        .receipt-table th, .receipt-table td {
            border: 1px solid #ddd;
            padding: 10px;
            text-align: left;
        }
        .receipt-table th {
            background-color: #f2f2f2;
        }
        .total-row {
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Payment Receipt</h1>
        <?php if(isset($_POST['paymentMethod'])) { ?>
            <p class="message"><?php echo $message; ?></p>
            <?php if (isset($result_cart) && $result_cart->num_rows > 0) { ?>
                <table class="receipt-table">
                    <thead>
                        <tr>
                            <th>Item Name</th>
                            <th>Price</th>
                            <th>Quantity</th>
                            <th>Subtotal</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($row = $result_cart->fetch_assoc()) { ?>
                            <tr>
                                <td><?php echo $row['item_name']; ?></td>
                                <td><?php echo $row['item_price']; ?></td>
                                <td><?php echo $row['quantity']; ?></td>
                                <td><?php echo $row['subtotal']; ?></td>
                            </tr>
                        <?php } ?>
                        <tr class="total-row">
                            <td colspan="3" style="text-align: right;">Total:</td>
                            <td>
                                <?php
                                    $total = 0;
                                    $result_cart->data_seek(0); // Reset the pointer to the beginning of the result set
                                    while ($row = $result_cart->fetch_assoc()) {
                                        $total += $row['subtotal'];
                                    }
                                    echo $total;
                                ?>
                            </td>
                        </tr>
                    </tbody>
                </table>
            <?php } ?>
        <?php } else { ?>
            <p class="message">Please submit the payment method form to generate the receipt.</p>
        <?php } ?>
    </div>
</body>
</html>
