<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Warong Nasi Ambeng Bonda</title>
    
    <!-- Meta Description for SEO -->
    <meta name="description" content="Warong Nasi Ambeng Bonda menyediakan hidangan nasi ambeng tradisional yang autentik dan lazat. Nikmati makanan kampung yang segar, berkualiti tinggi dan servis mesra di lokasi strategik kami. Tempah meja atau semak pesanan dengan mudah secara online.">
    
    <!-- Meta Keywords (optional, less impactful now but still used sometimes) -->
    <meta name="keywords" content="Nasi Ambeng, Warong Nasi Ambeng, Makanan Tradisional, Hidangan Kampung, Tempah Meja, Semak Pesanan, Makanan Malaysia, Masakan Melayu">

    <!-- Meta Author -->
    <meta name="author" content="Warong Nasi Ambeng Bonda">

    <!-- Responsive viewport -->
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Link to Poppins font -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">
</head>


<body class="form-v6">

    <?php
// Start or resume the session
session_start();
date_default_timezone_set('Asia/Kuala_Lumpur');
$datetime = date('Y-m-d H:i:s');

// Include the database configuration file
include 'config.php';

// Check if the form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Prepare data for insertion
    $name = $_POST['name'];
    $phone = $_POST['phone'];
    $table_number = isset($_POST['table_number']) ? intval($_POST['table_number']) : null;

    // Initialize user_id
    $user_id = null;

    // Use prepared statements to avoid SQL injection
    $stmt = $conn->prepare("INSERT INTO user_info (name, phone, table_number, created_at) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("ssis", $name, $phone, $table_number, $datetime);

    if ($stmt->execute()) {
        $user_id = $stmt->insert_id;
    } else {
        echo "Error: " . $stmt->error;
        exit();
    }
    $stmt->close();

    // Store user_id in session
    if ($user_id !== null) {
        $_SESSION['user_id'] = $user_id;

        // Check if user_id exists in user_info2 table
        $check_query_user_info2 = "SELECT user_id FROM user_info2 WHERE user_id = ?";
        $stmt_check = $conn->prepare($check_query_user_info2);
        $stmt_check->bind_param("i", $user_id);
        $stmt_check->execute();
        $result_user_info2 = $stmt_check->get_result();

        if ($result_user_info2) {
            if ($result_user_info2->num_rows > 0) {
                $update_query = "UPDATE user_info2 SET name = ?, phone = ?, updated_at = ? WHERE user_id = ?";
                $stmt_update = $conn->prepare($update_query);
                $stmt_update->bind_param("sssi", $name, $phone, $datetime, $user_id);
                if ($stmt_update->execute()) {
                    echo "User information updated successfully.";
                } else {
                    echo "Error: " . $stmt_update->error;
                }
                $stmt_update->close();
            } else {
                $sql2 = "INSERT INTO user_info2 (user_id, name, phone, updated_at) VALUES (?, ?, ?, ?)";
                $stmt_insert2 = $conn->prepare($sql2);
                $stmt_insert2->bind_param("isss", $user_id, $name, $phone, $datetime);
                if ($stmt_insert2->execute()) {
                    echo "User information inserted successfully.";
                } else {
                    echo "Error: " . $stmt_insert2->error;
                }
                $stmt_insert2->close();
            }
        } else {
            echo "Error: " . $check_query_user_info2 . "<br>" . $conn->error;
        }
        $stmt_check->close();
    } else {
        echo "Error: User ID is null.";
    }

    // Redirect after processing
    header("Location: home.php");
    exit();
}
?>


    <div class="logo-container">
        <img src="logo_nasi_ambeng.webp" alt="Logo">
    </div>

<!-- Page Content -->
<div class="page-content">
    <div class="form-v6-content">
        <div class="form-detail">
            <h2>Masukkan Maklumat Anda</h2>
            <form id="userInfoForm" method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>">
                <div class="form-row">
                    <label for="name">Nama:</label>
                    <input type="text" id="name" name="name" class="input-text" placeholder="Nama Anda" required>
                </div>

                <div class="form-row">
                    <label for="phone">Nombor Telefon:</label>
                    <input type="text" id="phone" name="phone" class="input-text" placeholder="Nombor Telefon" required>
                </div>

                <!-- Hidden field for table number -->
               <input type="hidden" name="table_number" id="table_number">

              

                <div class="form-row-last">
    <button type="button" onclick="showTablePopup()" class="register">Hantar</button>

    <!-- Semak Pesanan Button -->
    <button type="button" id="showOrderInputButton" onclick="toggleOrderNumberInput()" class="register" style="margin-top:10px;">
        Semak Pesanan
    </button>

    <!-- Order Number Field -->
    <div class="form-row" id="orderNumberRow" style="display: none;">
        <label for="order_number" style="margin-top:10px; text-align:left;">Nombor Pesanan:</label>
        <input type="text" id="order_number" name="order_number" class="input-text" placeholder="Contoh: 12345">
        <button type="button" onclick="checkOrderNumber()" class="register" style="margin-top:10px;">Semak</button>
        <button type="button" onclick="hideOrderNumberInput()" class="register" style="margin-top:10px; background:red; color:white;">Batal</button>
    </div>

    <!-- Modal Popup -->
    <div id="orderModal" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeOrderModal()">&times;</span>
            <div id="orderDetails"></div>
        </div>
    </div>
    </div>

   <!-- Modal Popup for Table Selection -->
<div id="tablePopup" style="
    display: none; 
    position: fixed; 
    top: 20%; 
    left: 50%; 
    transform: translateX(-50%); 
    background: #fff; 
    border: 1px solid #ccc; 
    padding: 20px; 
    z-index: 999;
    max-height: 70vh;      
    overflow-y: auto;      
    box-shadow: 0 4px 8px rgba(0,0,0,0.2); 
    border-radius: 8px;
">
    <h3>Pilih Meja Anda</h3>
    <div style="display: flex; flex-direction: column; gap: 10px;">
        <?php for ($i = 1; $i <= 11; $i++): ?>
            <button type="button" onclick="selectTable(<?php echo $i; ?>)">Meja <?php echo $i; ?></button>
        <?php endfor; ?>
    </div>
    <br>
    <button type="button" onclick="hidePopup()" style="background: red; color: white;">Cancel</button>
</div>


            </form>
        </div>
    </div>
</div>


   <!-- Modal Popup -->
<div id="orderModal" class="modal">
    <div class="modal-content">
        <!-- If you want to remove the 'x' close button, remove the span below -->
        <span class="close" onclick="closeOrderModal()" style="cursor:pointer; position:absolute; top:10px; right:15px; font-size:24px;">&times;</span>
        <div id="orderDetails"></div>
        <!-- Optional close button inside modal -->
        <button onclick="closeOrderModal()" style="margin-top: 15px;">Close</button>
    </div>
</div>

 <style>
        /* Reset and base styles */
        body {
            margin: 0;
            padding: 0;
            background: #f9f9f9;
            color: #333;
            font-family: 'Poppins', sans-serif;
        }

        .logo-container {
            text-align: center;
            margin-top: 20px;
            margin-bottom: 15px;
        }

        .logo-container img {
            max-width: 150px;
            height: auto;
        }

        /* Container for form */
        .page-content {
            padding: 20px;
        }

        /* Form container */
        .form-v6-content {
            background: #fff;
            border-radius: 10px;
            padding: 20px;
            max-width: 500px;
            margin: auto;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }

        /* Form heading */
        .form-detail h2 {
            text-align: center;
            margin-bottom: 20px;
            font-size: 1.5em;
            font-weight: 600;
        }

        /* Form row styling */
        .form-row {
            margin-bottom: 15px;
        }

        .form-row label {
            display: block;
            margin-bottom: 5px;
            font-weight: 500;
            font-size: 0.95em;
        }

        .input-text {
            width: 100%;
            padding: 10px;
            font-size: 1em;
            border: 1px solid #ccc;
            border-radius: 5px;
            box-sizing: border-box;
        }

        /* Submit button */
        .form-row-last {
            text-align: center;
        }

        button.register {
            background-color: #6e3b27;
            color: #fff;
            border: none;
            padding: 12px 20px;
            font-size: 1em;
            font-weight: 500;
            border-radius: 5px;
            cursor: pointer;
            width: 100%;
        }

        button.register:hover {
            background-color: rgb(114, 75, 60);
        }

        /* Table popup styling */
        #tablePopup {
            width: 90%;
            max-width: 300px;
            padding: 20px;
            background: #fff;
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.2);
            z-index: 9999;
        }

        #tablePopup h3 {
            margin-top: 0;
            text-align: center;
            font-size: 1.2em;
            font-weight: 600;
        }

        #tablePopup button {
            padding: 10px;
            font-size: 1em;
            border: none;
            background-color: #6e3b27;
            color: #fff;
            border-radius: 5px;
            cursor: pointer;
        }

        #tablePopup button:hover {
            background-color:rgb(116, 75, 58);
        }

        #tablePopup button[style*="background:red"] {
            background-color: #dc3545 !important;
        }

        #tablePopup button[style*="background:red"]:hover {
            background-color: #c82333 !important;
        }

        /* Check Order Number Popup styling (standardized with earlier CSS) */
#orderNumberPopup {
    width: 90%;
    max-width: 300px;
    padding: 20px;
    background: #fff;
    border-radius: 10px;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.2);
    position: fixed;
    top: 20%;
    left: 50%;
    transform: translateX(-50%);
    z-index: 9999;
}

#orderNumberPopup h3 {
    margin-top: 0;
    text-align: center;
    font-size: 1.2em;
    font-weight: 600;
}

#orderNumberPopup input {
    width: 100%;
    padding: 10px;
    font-size: 1em;
    border: 1px solid #ccc;
    border-radius: 5px;
    margin-bottom: 15px;
    box-sizing: border-box;
}

#orderNumberPopup button {
    padding: 10px;
    font-size: 1em;
    border: none;
    background-color: #6e3b27;
    color: #fff;
    border-radius: 5px;
    cursor: pointer;
    width: 100%;
}

#orderNumberPopup button:hover {
    background-color: rgb(116, 75, 58);
}

#orderNumberPopup button.cancel-btn {
    background-color: #dc3545;
}

#orderNumberPopup button.cancel-btn:hover {
    background-color: #c82333;
}

.modal {
  display: none; /* Hidden by default */
  position: fixed; /* Stay in place */
  z-index: 1000; /* Sit on top */
  left: 0;
  top: 0;
  width: 100%; /* Full width */
  height: 100%; /* Full height */
  overflow: auto; /* Enable scroll if needed */
  background-color: rgba(0,0,0,0.5); /* Black with opacity */
}

/* Modal Content Box */
.modal-content {
  background-color: #fff;
  margin: 10% auto; /* 10% from top, centered horizontally */
  padding: 20px;
  border-radius: 8px;
  width: 80%; /* or any width you want */
  max-width: 500px; /* max width */
  box-shadow: 0 5px 15px rgba(0,0,0,0.3);
  position: relative;
}

/* Responsive adjustments */
@media (max-width: 600px) {
    #orderNumberPopup {
        width: 95%;
    }

    #orderNumberPopup button {
        padding: 8px;
        font-size: 0.95em;
    }
}
        /* Responsive adjustments */
        @media (max-width: 600px) {
            .form-v6-content {
                padding: 15px;
            }

            .form-detail h2 {
                font-size: 1.2em;
            }

            button.register {
                font-size: 1em;
                padding: 10px 15px;
            }

            #tablePopup {
                width: 95%;
                left: 50%;
                transform: translateX(-50%);
            }

            #tablePopup button {
                padding: 8px;
                font-size: 0.95em;
            }
        }

    </style>




<script>
function showTablePopup() {
    const name = document.getElementById('name').value.trim();
    const phone = document.getElementById('phone').value.trim();

    if (name === '') {
        alert('Sila masukkan nama anda terlebih dahulu.');
        document.getElementById('name').focus();
        return;
    }
    if (phone === '') {
        alert('Sila masukkan nombor telefon anda terlebih dahulu.');
        document.getElementById('phone').focus();
        return;
    }

    // Both fields filled, show the popup
    document.getElementById('tablePopup').style.display = 'block';
}

function hidePopup() {
    // Hide the popup
    document.getElementById('tablePopup').style.display = 'none';
    // Do nothing else — no reset or submission.
}

function selectTable(tableNumber) {
    document.getElementById('table_number').value = tableNumber;
    document.getElementById('userInfoForm').submit();
}


function toggleOrderNumberInput() {
    document.getElementById('orderNumberRow').style.display = 'block';
    document.getElementById('showOrderInputButton').style.display = 'none';
}

function hideOrderNumberInput() {
    document.getElementById('orderNumberRow').style.display = 'none';
    document.getElementById('order_number').value = '';
    document.getElementById('showOrderInputButton').style.display = 'inline-block';
}

function checkOrderNumber() {
    const orderNumber = document.getElementById('order_number').value.trim();
    if (orderNumber === '') {
        alert('Sila masukkan nombor pesanan.');
        return;
    }

    // AJAX request
    const xhr = new XMLHttpRequest();
    xhr.open('POST', 'check_order.php', true);
    xhr.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
    xhr.onload = function() {
        if (xhr.status === 200) {
            document.getElementById('orderDetails').innerHTML = xhr.responseText;
            document.getElementById('orderModal').style.display = 'block';
        } else {
            alert('Ralat memuatkan pesanan.');
        }
    };
    xhr.send('order_number=' + encodeURIComponent(orderNumber));
}

function closeOrderModal() {
    document.getElementById('orderModal').style.display = 'none';
}
</script>

</body>

</html>
