



<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="utf-8">
	<title>Form-v6 by Colorlib</title>
	<!-- Mobile Specific Metas -->
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
	<!-- Font-->
	<link rel="stylesheet" type="text/css" href="nunito-font.css">
	<!-- Main Style Css -->
    <link rel="stylesheet" href="style.css"/>

<style>
    #bg-video {
    width: 20%; /* Set the width to 50% of its container */
    /* You can also specify specific width and height values */
    /* width: 400px; */
    /* height: 300px; */
}

</style>
   
</head>


<body class="form-v6">
	<div class="page-content">
		<div class="form-v6-content">


	<div class="form-left">
      <video autoplay muted loop id="bg-video">
        <source src="mp3.mp4" type="video/mp4">
        <!-- Add additional source elements for different video formats if needed -->
        Your browser does not support the video tag.
    </video>
</div>

<?php
// Include config.php to establish database connection
include "config.php";

// Initialize variables to store user input
$email = $password = "";
$email_err = $password_err = "";

// Check if the form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Check if email and password are empty
    if (empty(trim($_POST["email"]))) {
        $email_err = "Please enter your email.";
    } else {
        $email = trim($_POST["email"]);
    }
    if (empty(trim($_POST["password"]))) {
        $password_err = "Please enter your password.";
    } else {
        $password = trim($_POST["password"]);
    }

    // Validate credentials
    if (empty($email_err) && empty($password_err)) {
        // Prepare a select statement
        $sql = "SELECT id, email, password FROM adminhost WHERE email = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("s", $email);

        // Attempt to execute the prepared statement
        if ($stmt->execute()) {
            // Store result
            $stmt->store_result();

            // Check if email exists, then verify password
            if ($stmt->num_rows == 1) {
                // Bind result variables
                $stmt->bind_result($id, $email, $hashed_password);
                if ($stmt->fetch()) {
                    if (password_verify($password, $hashed_password)) {
                        // Password is correct, start a new session
                        session_start();

                        // Store data in session variables
                        $_SESSION["id"] = $id;
                        $_SESSION["email"] = $email;

                        // Redirect user to welcome page
                        header("location: admin1.php");
                    } else {
                        // Display an error message if password is not valid
                        $password_err = "The password you entered is not valid.";
                    }
                }
            } else {
                // Display an error message if email doesn't exist
                $email_err = "No account found with that email.";
            }
        } else {
            echo "Oops! Something went wrong. Please try again later.";
        }

        // Close statement
        $stmt->close();
    }

    // Close connection
    $conn->close();
}
?>



<div class="form-detail">
<h2>Login to Your Account</h2>


              <form id="loginForm" method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>">
                 <div class="form-row">
                  <label for="email">Email:</label>
                        <input type="email" id="email" name="email" class="input-text" placeholder="Your Email" required>
                    </div>

                    <div class="form-row">
                        <label for="password">Password:</label>
                        <input type="password" id="password" name="password" class="input-text" placeholder="Your Password" required>
                    </div>
                    <div class="form-row-last">
                        <input type="submit" value="Login" class="register" name="login">
                    </div>
             </form>


</div>



    <script>
        function startOrder() {
            // Show the spinner
            document.getElementById('spinner').style.display = 'block';
            
            // Redirect to the order page after a delay
            setTimeout(function() {
                // Assuming you want to submit the form data to another page
                document.getElementById('userInfoForm').submit();
            }, 2000); // Adjust the delay time as needed (in milliseconds)
        }
    </script>

 
</body>
</html>
