<?php
// Start session to access session variables
session_start();

// Retrieve the user_id from the session
$user_id = $_SESSION['user_id'];

// Check if user_id is set
if(isset($user_id)) {
    // If user_id is set, do not display it
} else {
    // If user_id is not set, display a message
    echo "<div>User ID not available</div>";
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Your Website</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Pacifico&display=swap" rel="stylesheet">

    <script src="https://maps.googleapis.com/maps/api/js?key=YOUR_API_KEY&callback=initMap" async defer></script>
    <link href="https://fonts.googleapis.com/css2?family=Pacifico&display=swap" rel="stylesheet">
    <script src="https://js.stripe.com/v3/"></script>
    <link rel="stylesheet" href="path/to/vendorlane.min.css">
    <script src="path/to/vendorlane.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/hammerjs"></script>
    <link rel="stylesheet" href="style5.css">

    <script src="anggun.js"></script>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Open+Sans&display=swap">

    <link rel="stylesheet" type="text/css" href="css2/bootstrap.min.css">
      <!-- style css -->
      <link rel="stylesheet" type="text/css" href="css2/style.css">
      <!-- Responsive-->
      <link rel="stylesheet" href="css2/responsive.css">
      <!-- fevicon -->
      <link rel="icon" href="images/fevicon.png" type="image/gif" />
      <!-- Scrollbar Custom CSS -->
      <link rel="stylesheet" href="css2/jquery.mCustomScrollbar.min.css">
      <!-- Tweaks for older IEs-->
      <link rel="stylesheet" href="https://netdna.bootstrapcdn.com/font-awesome/4.0.3/css/font-awesome.css">
      <!-- owl stylesheets --> 
      <link rel="stylesheet" href="css2/owl.carousel.min.css">
      <link rel="stylesheet" href="css2/owl.theme.default.min.css">
      <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/fancybox/2.1.5/jquery.fancybox.min.css" media="screen">

    <style>/* Styles for gallery section */

.content-section {
   
    padding: 20px;
    margin: 20px 0;
    border: 1px solid #ffff;
    border-radius: 8px;
 
    font-family: Arial, sans-serif;
    color: #000000;
}

.main {
    padding: 20px;
    margin: 10px auto;
    display: flex
}
.gallery_section {
    background-color: #eb9553;
    padding: 50px 0;
}

.gallery_taital {
    text-align: center;
    font-size: 36px;
    margin-bottom: 30px;
    color: #333;
}

.gallery_text {
    text-align: center;
    font-size: 18px;
    margin-bottom: 50px;
    color: #666;
}

.gallery_section_2 {
    margin-bottom: 30px;
}

.container_main {
    position: relative;
    overflow: hidden;
}

.image {
    width: 100%;
    height: auto;
    transition: transform 0.3s ease;
}

.image:hover {
    transform: scale(1.05);
}

.overlay {
    position: absolute;
    top: 0;
    bottom: 0;
    left: 0;
    right: 0;
    background-color: rgba(0, 0, 0, 0.5);
    opacity: 0;
    transition: opacity 0.3s ease;
    display: flex;
    justify-content: center;
    align-items: center;
}

.overlay:hover {
    opacity: 1;
}

.text {
    color: #fff;
    font-size: 24px;
}

.text a {
    color: #fff;
    text-decoration: none;
}

.text a:hover {
    text-decoration: underline;
}

.seemore_bt {
    text-align: center;
    margin-top: 30px;
}

.seemore_bt a {
    background-color: #eb9553;
    color: #fff;
    padding: 15px 30px;
    text-decoration: none;
    border-radius: 5px;
    transition: background-color 0.3s ease;
}

.seemore_bt a:hover {
    background-color: #d07d45;
}

/* Media Queries for responsive design */
@media only screen and (max-width: 768px) {
    .gallery_taital {
        font-size: 30px;
    }
    
    .gallery_text {
        font-size: 16px;
    }
}

@media only screen and (max-width: 576px) {
    .gallery_taital {
        font-size: 24px;
    }
    
    .gallery_text {
        font-size: 14px;
    }
}

        
   
    .modal {
  display: none; /* Hidden by default */
  position: fixed; /* Stay in place */
  z-index: 1; /* Sit on top */
  left: 0;
  top: 0;
  width: 100%;
  height: 100%;
  overflow: auto; /* Enable scroll if needed */
  background-color: rgb(0,0,0); /* Fallback color */
  background-color: rgba(0,0,0,0.4); /* Black w/ opacity */
}

/* Modal content box */
.modal-content {
  background-color: #fefefe;
  margin: 15% auto; /* 15% from the top and centered */
  padding: 20px;
  border: 1px solid #888;
  width: 80%; /* Could be more or less, depending on screen size */
}

#person {
        background-color: #f9f9f9;
        border: 1px solid #ddd;
        border-radius: 5px;
        padding: 20px;
        margin: 20px auto;
        max-width: 600px;
    }

    /* Style for the profile data */
    .profile-data {
        margin-bottom: 10px;
    }t

    .profile-data label {
        font-weight: bold;
    }

    /* Style for the profile heading */
    .profile-heading {
        margin-bottom: 20px;
        text-align: center;
    }



/* Close button */
.close {
  color: #aaa;
  float: right;
  font-size: 28px;
  font-weight: bold;
}


#checkout-content {
    
    padding: 20px;
    margin-bottom: 20px;
}

.close:hover,
.close:focus {
  color: black;
  text-decoration: none;
  cursor: pointer;
}



nav {
    display: flex;
    align-items: center; /* Vertically align items */
}

.menu-drink {
   
    border-radius: 20px;
}

.menu {
    list-style-type: none;
    margin: 0;
    padding: 0;
    display: flex;
    align-items: center; /* Vertically align items */
    margin-left: auto; /* Move the menu to the right */
    overflow: hidden; /* Hide any content that overflows the container */

}


.menu li {
    margin-right: 10px; /* Adjust margin to move items slightly to the right */
}

.menu li:last-child {
    margin-right: 0;
}

.menu li a {
    color: #050505;
    text-decoration: none;
    font-weight: bold;
}

.menu li a:hover {
    color: #fff; /* Change text color on hover */
}

.menu li a i {
    margin-right: 5px;
}

.menu-container {
    max-width: 100%; /* Set maximum width */
    padding: 10px; /* Add padding as needed */
  
    box-sizing: border-box; /* Include padding and border in the element's total width and height */
    overflow: hidden; /* Hide any content that overflows the container */
}



/* Default styles for menu */
.menu {
    white-space: nowrap; /* Prevent line breaks */
    overflow-x: auto; /* Allow horizontal scrolling when necessary */
}

.logo-container {
    text-align: center; /* Center the logo horizontally */
}

.logo {
    max-width: 200px; /* Adjust the max-width as needed */
    height: auto; /* Maintain aspect ratio */
}




.menu-toggle {
    display: none; /* Hide toggle button by default */
}

.logo-commerce {
    overflow: hidden; /* Clear floats */
}

.logo {
    float: left; /* Float the image to the left */
    margin-right: 10px; /* Add some margin for spacing */
}


@media only screen and (max-width: 768px) {
  body {
    font-family: Arial, Helvetica, sans-serif;
  }

  .mobile-container {
    max-width: 480px;
    margin: auto;
    background-color: #555;
    height: 500px;
    color: white;
    border-radius: 10px;
  }

  .topnav {
    overflow: hidden;
    
    position: relative;
  }

  .topnav #myLinks {
    display: none;
  }

  .topnav a {
    color: white;
    padding: 14px 16px;
    text-decoration: none;
    font-size: 17px;
    display: block;
  }

 

  .topnav a:hover {
    background-color: #ddd;
    color: black;
  }

  .active {
    background-color: #04AA6D;
    color: white;
  }





  .menu-toggle {
    margin-left: auto;
    display: block;
    background-color: #f0f0f0;
    color: #333;
    border: none;
    cursor: pointer;
    padding: 10px;
    outline: none;
    margin-left: 10px;
    transition: background-color 0.3s ease; /* Add transition for background color */
    animation: fadeInDown 0.5s ease; /* Add animation for toggle */
  }

  .menu-toggle:hover {
    background-color: #ccc; /* Change background color on hover */
  }

  .menu {
    display: none;
    transition: max-height 0.3s ease; /* Add transition for max-height */
    max-height: 0;
    overflow: hidden;
    width: 100%;
    background-color: #f0f0f0;
    padding: 10px;
    box-sizing: border-box;
    animation: slideInDown 0.5s ease; /* Add animation for menu */
  }

 
  .logo-container {
    text-align: center; /* Center the logo horizontally */
    width: 100%; /* Make the container occupy full viewport width */
    margin-bottom: 10px; /* Add margin as needed */
  }

  .logo {
    max-width: 100%; /* Ensure the logo fits within the container */
    height: auto; /* Maintain aspect ratio */
    display: inline-block; /* Ensure the logo container expands to fit its contents */
  }

  .menu.active {
    display: block;
    max-height: 200px;
  }

  

  

  .menu li {
    margin-right: 0;
    margin-bottom: 10px;
    margin-right: auto; /* Add space between icon and text */
    text-align: center; /* Center text horizontally */
    
  }


.footer-columns {
        display: flex;
        flex-direction: column;
        align-items: center;
        text-align: center;
    }

    .column-bawah {
        margin-bottom: 20px; /* Add margin between columns */
    }

    .column-bawah:last-child {
        margin-bottom: 0; /* Remove margin for the last column */
    }

    .column-bawah {
        padding: auto; /* Add padding to the columns */
        background-color: #f0f0f0; /* Add background color to distinguish columns */
        border-radius: 5px; /* Add border radius for better appearance */
    }

    .column-bawah h3 {
        margin-top: 0; /* Remove top margin for the heading */
    }

    .column-bawah p.address {
        margin-bottom: 10px; /* Add bottom margin for the address */
    }

  




  @keyframes fadeInDown {
    from {
      opacity: 0;
      transform: translateY(-20px);
    }
    to {
      opacity: 1;
      transform: translateY(0);
    }
  }

  @keyframes slideInDown {
    from {
      transform: translateY(-100%);
    }
    to {
      transform: translateY(0);
    }
  }
}
.menu-item-3 {
  
  margin: 15px;
  display: inline-block;
  vertical-align: top;
  text-align: center; /* center image, name, price */
}

.menu-item-3 img {
  max-width: 100%;
  height: auto;
  border-radius: 20px;
  margin-bottom: 10px;
}

.menu-food h3 {
  font-size: 20px;
  margin: -10px 0 5px;
}

.menu-food p {
  font-size: 16px;
  color: #555;
  margin: -10px 0 5px;
  font-weight: bold;
}

/* quantity section centered */
.quantity-wrapper {
  display: flex;
  justify-content: center;
  align-items: center;
  margin-bottom: 10px;
}


/* add-to-cart aligned to the left */
.add-to-cart-form-food {
  text-align: center;
}

.add-button {
    display: inline-block;
    padding: 8px 16px;
    background-color: #28a745 !important; /* green for add */
    color: white;
    border: none;
    border-radius: 5px;
    cursor: pointer;
    font-family: 'Poppins', sans-serif;
    font-weight: 600;
    transition: background-color 0.3s ease;
    text-align: center;
    user-select: none;
}

.add-button:hover {
    background-color: #218838; /* darker green on hover */
}

.remove-button {
    display: inline-block;
    padding: 8px 16px;
    background-color: #28a745 !important; /* green for add */
    color: white;
    border: none;
    border-radius: 5px;
    cursor: pointer;
    font-family: 'Poppins', sans-serif;
    font-weight: 600;
    transition: background-color 0.3s ease;
    text-align: center;
    user-select: none;
}

.remove-button:hover {
    background-color: #c82333; /* darker red on hover */
}






    </style>
</head>
<body>

<style>
    @font-face {
    font-family: 'YourChosenFont';
    src: url('your-font-file.woff2') format('woff2'),
         url('your-font-file.woff') format('woff');
    /* Add more src declarations for different font file formats if necessary */
}
/* Logo Link */
.topnav .logo-link {
  display: flex;
  align-items: center;
  justify-content: center;
  height: 100%;
}

/* Logo Image */
.topnav .logo-img {
  height: 150px; /* Adjust based on your logo's aspect ratio */
  width: auto;
  object-fit: contain;
}

</style>
<!-- Simulate a smartphone / tablet -->


<div class="topnav">
<a href="#home" class="logo-link">
    <img src="Logo N.A.png" alt="NASI AMBENG Logo" class="logo-img">
  </a><!-- Hamburger Button for Mobile -->



<button class="hamburger" onclick="toggleSidebar()">
  <i class="fas fa-bars"></i>
</button>

</div>



<!-- Top Navigation Menu 
    <div id="myLinks">
        <a href="#" onclick="showContent('person')"><i class="fas fa-user"></i> Person</a>
        <a href="#" onclick="showContent('cart')"><i class="fas fa-shopping-cart"></i> Cart</a>
        <a href="#" onclick="showContent('complete')"><i class="fas fa-check-circle"></i> Complete</a>
    </div>
    <a href="javascript:void(0);" class="icon" onclick="myFunction()">
        <i class="fa fa-bars"></i>
    </a>
    -->


<a href="javascript:void(0);" onclick="showContent('cart')" class="cart-icon">
  <i class="fas fa-shopping-cart"></i>
  <span class="cart-count" id="cart-count"><?php echo $totalItems; ?></span>
</a>

<script>
function refreshCartCount() {
  fetch('get_cart_count.php')
    .then(response => response.text())
    .then(count => {
      document.getElementById('cart-count').textContent = count;
    })
    .catch(error => console.error('Error fetching cart count:', error));
}

// Refresh every 5 seconds
setInterval(refreshCartCount, 5000);

// Optionally run once immediately
refreshCartCount();
</script>


<style>
    .cart-icon {
  position: fixed;
  bottom: 20px;    /* distance from bottom */
  right: 20px;     /* distance from right */
  background-color: #2d632d;
  color: white;
  font-size: 24px;
  padding: 12px 16px;
  border-radius: 50%;
  box-shadow: 0 4px 10px rgba(0,0,0,0.3);
  z-index: 999;
  text-decoration: none;
  display: flex;
  align-items: center;
  justify-content: center;
  transition: background-color 0.3s ease;
}

.cart-icon:hover {
  background-color:rgb(0, 0, 0);
}

.cart-count {
  background: red;
  color: white;
  font-size: 12px;
  padding: 2px 6px;
  border-radius: 50%;
  position: absolute;
  top: 5px;
  right: 5px;
}

</style>


<script>
function myFunction() {
  var x = document.getElementById("myLinks");
  if (x.style.display === "block") {
    x.style.display = "none";
  } else {
    x.style.display = "block";
  }
}
</script>




<!-- Desktop Navigation -->
<nav class="top-nav desktop-nav">
  <ul class="icon-list">
    <li><a href="#" onclick="showContent('home')"><i class="fas fa-home"></i> Home</a></li>
    <li><a href="#" onclick="showContent('food')"><i class="fas fa-utensils"></i> Aneka lauk</a></li>
    <li><a href="#" onclick="showContent('drink')"><i class="fas fa-cocktail"></i> Minuman</a></li>
    <li><a href="#" onclick="showContent('masakan-panas')"><i class="fas fa-fire"></i> Masakan Panas</a></li>
    <li><a href="#" onclick="showContent('set-nasi')"><i class="fas fa-drumstick-bite"></i> Set Nasi & Lauk</a></li>
    <li><a href="#" onclick="showContent('pencuci-mulut')"><i class="fas fa-ice-cream"></i> Pencuci Mulut</a></li>
    <li><a href="#" onclick="showContent('catering')"><i class="fas fa-concierge-bell"></i> Catering</a></li>

  </ul>
</nav>



<!-- Sidebar Navigation for Mobile -->
<nav id="sidebar" class="sidebar">
  <ul class="icon-list">
    <li><a href="#" onclick="showContent('home')"><i class="fas fa-home"></i> Home</a></li>
    <li><a href="#" onclick="showContent('food')"><i class="fas fa-utensils"></i> Lauk lauk</a></li>
    <li><a href="#" onclick="showContent('drink')"><i class="fas fa-cocktail"></i> Minuman</a></li>
    <li><a href="#" onclick="showContent('masakan-panas')"><i class="fas fa-fire"></i> Masakan Panas</a></li>
    <li><a href="#" onclick="showContent('set-nasi')"><i class="fas fa-drumstick-bite"></i> Set Nasi & Lauk</a></li>
    <li><a href="#" onclick="showContent('pencuci-mulut')"><i class="fas fa-ice-cream"></i> Pencuci Mulut</a></li>
    <li><a href="#" onclick="showContent('catering')"><i class="fas fa-concierge-bell"></i> Catering</a></li>

  </ul>
</nav>

<script>
  function toggleSidebar() {
    document.getElementById('sidebar').classList.toggle('active');
  }

  // Close sidebar when a menu item is clicked
  document.querySelectorAll('#sidebar .icon-list a').forEach(link => {
    link.addEventListener('click', () => {
      document.getElementById('sidebar').classList.remove('active');
    });
  });

  // Close sidebar when clicking outside of it
  document.addEventListener('click', function(event) {
    const sidebar = document.getElementById('sidebar');
    const hamburger = document.querySelector('.hamburger');
    if (
      sidebar.classList.contains('active') &&
      !sidebar.contains(event.target) &&
      !hamburger.contains(event.target)
    ) {
      sidebar.classList.remove('active');
    }
  });
</script>


<style>
    /* Base Styles */
.desktop-nav {
  display: block;
}

.hamburger,
.sidebar {
  display: none;
}

/* Mobile Styles */
@media screen and (max-width: 768px) {
  .desktop-nav {
    display: none;
  }

  .hamburger {
    display: block;
    position: fixed;
    top: 15px;
    left: 15px;
    background: none;
    border: none;
    font-size: 24px;
    z-index: 1001;
    color: #000;
  }

  .sidebar {
    display: block;
    position: fixed;
    top: 0;
    left: -250px; /* Hidden by default */
    width: 250px;
    height: 100%;
    background-color: #e8ebeb;
    padding-top: 60px;
    transition: left 0.3s ease;
    z-index: 1000;
  }

  .sidebar.active {
    left: 0;
  }

  .icon-list {
    list-style-type: none;
    padding: 0;
    margin: 0;
  }

  .icon-list li {
    margin: 10px 0;
  }

  .icon-list li a {
    display: flex;
    align-items: center;
    padding: 10px 20px 10px 15px;
    color: #000;
    text-decoration: none;
    font-size: 16px;
    transition: background-color 0.3s ease;
  }

  .icon-list li a i {
        margin-right: 5px; /* Add space between icon and text */
    }

  .icon-list li a:hover {
    background-color: #e0e0e0;
  }
}

</style>
 
    
    
    
    
    
   <div class="main">

   <style>
    button[type="submit"] {
    background-color: #6e3b27;
    padding: 15px 20px;
    border: none;
    border-radius: 5px;
    cursor: pointer;
    font-size: 16px;
    font-weight: bold;
}

button[type="submit"]:hover {
    background-color:rgb(223, 188, 144);
}
 /* Styles for the content section */
 .menu li {
    display: inline-block;
    margin-right: 20px;
}

/* Style for the links */
.menu li a {
    color: #C67336;
    text-decoration: none;
    transition: color 0.3s ease; /* Add transition effect for color */
}

/* Hover effect for the links */
.menu li a:hover {
    color: #f00; /* Change color on hover */

}.top-nav {
    background-color:rgb(255, 255, 255);
    padding: 10px;

}

/* Style for the list items */

/* Gaya umum untuk pautan navigasi */
.top-nav .icon-list li a {
  font-size: 16px;           /* Saiz fon asas */
  color: #000;               /* Warna teks hitam */
  text-decoration: none;     /* Menghilangkan garis bawah */
  padding: 10px 15px;        /* Ruang dalam pautan */
  display: inline-block;     /* Membolehkan padding berfungsi dengan baik */
}

/* Kesan hover untuk pautan navigasi */
.top-nav .icon-list li a:hover {
  color:rgb(255, 255, 255);            /* Warna teks semasa hover (oren terang) */
  font-size: 17px;           /* Saiz fon sedikit lebih besar semasa hover */
}

/* Hover effect for the links */
.icon-list li a:hover {
    background-color: #6e3b27;
    border-radius: 5px;
    padding: 5px 10px;
}

  .content-section {
    position: relative;
    width: 120%; /* Adjust width as needed */
    margin: 0 auto; /* Center the section horizontally */
    overflow: hidden; /* Hide overflowing images */
}

/* Styles for the vendor lane */
.vendor-lane {
    position: relative;
    display: flex;
    align-items: center;
    justify-content: center;
}

/* Styles for the image container */
.image-container {
    display: flex;
    transition: transform 0.5s ease; /* Smooth transition effect */
    gap:10px;

}

/* Styles for the images */
.image-container img {
    width: 20%; /* Reduce image size */
    height: auto; /* Maintain aspect ratio */
    object-fit: cover; /* Ensure images cover their container */
}

/* Styles for the swipe buttons */
#swipeLeft,
#swipeRight {
    position: absolute;
    top: 50%;
    transform: translateY(-50%);
    background-color: rgba(255, 255, 255, 0.5); /* Semi-transparent background */
    border: none;
    padding: 5px; /* Reduce padding */
    font-size: 16px; /* Reduce font size */
    cursor: pointer;
    z-index: 1; /* Ensure buttons are above images */
}

#swipeLeft {
    left: 5px; /* Adjust left position */
}

#swipeRight {
    right: 5px; /* Adjust right position */
}
/* Style for the main about section */
.about_section {
    background-color: #eb9553;
    padding: 50px 0; /* Adjust padding as needed */
    margin-top: 20px;

}

/* Style for the container within the about section */
.container2{
    max-width: 1200px; /* Adjust maximum width as needed */
    margin: 0 auto;
    padding: 0 15px;
}

/* Style for the row within the container */
.row {
    display: flex;
    flex-wrap: wrap;
    justify-content: space-between;
}

/* Style for the columns */
.col-md-6 {
    width: calc(50% - 15px); /* Adjust width and subtract margin */
    margin-bottom: 30px; /* Adjust margin as needed */
}

/* Style for the about text content */
.about_taital {
    font-size: 24px;
    font-weight: bold;
    margin-bottom: 15px;
}

.about_text {
    line-height: 1.6;
    margin-bottom: 15px;
}

/* Style for the read more button */
.read_bt a {
    background-color: #ff7d66;
    color: #fff;
    padding: 10px 20px;
    text-decoration: none;
    border-radius: 5px;
    display: inline-block;
}

.read_bt a:hover {
    background-color: #ff654d;
}



/* Style for the main about section */
.about_section2 {
    background-color: #eb9553;
    padding: 50px 0; /* Adjust padding as needed */
}

/* Style for the container within the about section */
.container3 {
    max-width: 1200px; /* Adjust maximum width as needed */
    margin: 0 auto;
    padding: 0 15px;
}

/* Style for the row within the container */
.row2{
    display: flex;
    flex-wrap: wrap;
    justify-content: space-between;
}

/* Style for the columns */
.col-md-62 {
    width: calc(50% - 15px); /* Adjust width and subtract margin */
    margin-bottom: 30px; /* Adjust margin as needed */
}

/* Style for the about text content */
.about_taital2 {
    font-size: 24px;
    font-weight: bold;
    margin-bottom: 15px;
}

.about_text2 {
    line-height: 1.6;
    margin-bottom: 15px;
}

/* Style for the read more button */
.read_bt2 a {
    background-color: #ff7d66;
    color: #fff;
    padding: 10px 20px;
    text-decoration: none;
    border-radius: 5px;
    display: inline-block;
}

.read_bt2 a:hover {
    background-color: #ff654d;
}

/* Style for the about image */
.about_img img {
    width: 80%;
    height: auto;
    display: block;
}




/* Responsive layout */
@media screen and (max-width: 768px) {

    .col-md-62 {
        width: 100%; /* Set column width to 100% for smaller screens */
    }
    .col-md-6 {
        width: 100%; /* Set column width to 100% for smaller screens */
    }
    .sidenav {
        width: 100%;
        float: none;
        margin-top: 0;
        height: auto;
        overflow-y: auto; /* Add overflow property */
        margin: auto;
    }

    /* Styles for the image container */
    .image-container {
    display: flex;
    justify-content: space-between; /* Add space between images */
    padding: 0 5px; /* Add padding to the container to create space at the ends */
    transition: transform 0.8s ease; /* Smooth transition effect */
    gap:10px;
}

/* Styles for the images */
.image-container img {
    width: 130%; /* Reduce image size */
    height: auto; /* Maintain aspect ratio */
    object-fit: cover; /* Ensure images cover their container */

}


}

   </style>



<section id="home" class="content-section">

  <!-- Content Wrapper -->
  <div class="content-wrapper">
    <!-- Main Content -->
    <div class="content-wrapper" style="flex: 1; ">
      
      <!-- Hero Section -->
      <div class="hero-section" style="text-align: center; padding: 80px 20px; background: url('images/hero-bg.jpg') center/cover no-repeat; border-radius: 16px; color: white;">
        <h1>Selamat Datang Ke Warong Nasi Ambeng Bonda</h1>
        <p style="max-width: 600px; margin: 20px auto;">Experience fine dining with premium ingredients, curated by world-class chefs. Order your favorite gourmet dishes from the comfort of your home.</p>
        <a href="#menu" style="padding: 12px 32px; background-color: #6e3b27; color: #fff; text-decoration: none; border-radius: 50px; font-weight: bold;">Explore Menu</a>
      </div>

      <!-- Menu Section -->
      <div id="menu" style="padding: 80px 20px;"> 
      <h2 style="text-align: center; font-size: 36px; color: #000; font-family: 'Poppins', sans-serif; font-weight: bold;"></h2>
        <div style="display: flex; gap: 30px; justify-content: center; flex-wrap: wrap; margin-top: 40px;">
          
        <!--
       
        
          <div style="background: #fff; border-radius: 12px; overflow: hidden; width: 300px; box-shadow: 0 4px 15px rgba(0,0,0,0.1);">
            <img src="https://tse1.mm.bing.net/th?id=OIP.E-BjPMblzK-pOrHGT9-d6AHaE8&w=316&h=316&c=7" alt="Gourmet Steak" style="width: 100%; height: 200px; object-fit: cover;">
            <div style="padding: 20px;">
              <h5>Gourmet Steak</h5>
              <p>A perfect cut of beef, grilled to perfection with fine spices.</p>
              <p><strong>$40.00</strong></p>
            </div>
          </div>

       
          <div style="background: #fff; border-radius: 12px; overflow: hidden; width: 300px; box-shadow: 0 4px 15px rgba(0,0,0,0.1);">
            <img src="https://tse1.mm.bing.net/th?id=OIP.zVtBH7kQxmwqtVznr4j9uAHaEK&w=266&h=266&c=7" alt="Truffle Pasta" style="width: 100%; height: 200px; object-fit: cover;">
            <div style="padding: 20px;">
              <h5>Truffle Pasta</h5>
              <p>Delicious pasta infused with truffles and rich cream sauce.</p>
              <p><strong>$30.00</strong></p>
            </div>
          </div>

          
          <div style="background: #fff; border-radius: 12px; overflow: hidden; width: 300px; box-shadow: 0 4px 15px rgba(0,0,0,0.1);">
            <img src="https://tse2.mm.bing.net/th?id=OIP.7PolZkEnYr7IbyxHFeR1bAHaGD&w=387&h=387&c=7" alt="Gourmet Salmon" style="width: 100%; height: 200px; object-fit: cover;">
            <div style="padding: 20px;">
              <h5>Gourmet Salmon</h5>
              <p>Fresh salmon served with an exquisite citrus glaze.</p>
              <p><strong>$35.00</strong></p>
            </div>
          </div>

           !-->

        </div>
      </div>

      <!-- Location Section -->
      <div id="location" style="padding: 80px 20px;">
        <h2 style="text-align: center; font-size: 36px; color:rgb(0, 0, 0); font-family: 'Poppins', sans-serif; font-weight: bold;">Lokasi Kami</h2>
        <p style="text-align: center; max-width: 600px; margin: 10px auto;">Datanglah ke Warong Nasi Ambeng Bonda di Taman Megah Ria, Masai, Johor – bersebelahan Masjid Hajah Maznah.</p>
        <div style="display: flex; justify-content: center; margin-top: 30px;">
          <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d15963.391639170014!2d103.84335489999999!3d1.4877394!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x31da6e80104e0579%3A0x358b74cd2152469e!2sMasjid%20Hajah%20Maznah!5e0!3m2!1sen!2smy!4v1713598200000" width="100%" height="350" style="border:0; border-radius: 16px; max-width: 800px;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
        </div>
      </div>

      <!-- Keistimewaan Section -->
      <div id="keistimewaan" style="padding: 80px 20px;">
        <h2 style="text-align: center; font-size: 36px; color:rgb(0, 0, 0); font-family: 'Poppins', sans-serif; font-weight: bold;">Keistimewaan Kami</h2>
        <div style="display: flex; flex-wrap: wrap; gap: 30px; justify-content: center; margin-top: 40px;">
          
          <!-- Kad 1 -->
          <div style="background: #fff; border-radius: 12px; padding: 30px; width: 300px; text-align: center; box-shadow: 0 4px 15px rgba(0,0,0,0.1);">
            <h4 style="color: #185910;">Harga Mampu Milik</h4>
            <p>Mulakan hari anda dengan nasi ambeng serendah <strong>RM6</strong> — berbaloi & mengenyangkan!</p>
          </div>

          <!-- Kad 2 -->
          <div style="background: #fff; border-radius: 12px; padding: 30px; width: 300px; text-align: center; box-shadow: 0 4px 15px rgba(0,0,0,0.1);">
            <h4 style="color: #185910;">Resepi Warisan</h4>
            <p>Dimasak mengikut tradisi keluarga — rasa asli Jawa yang tak lapuk dek zaman.</p>
          </div>

          <!-- Kad 3 -->
          <div style="background: #fff; border-radius: 12px; padding: 30px; width: 300px; text-align: center; box-shadow: 0 4px 15px rgba(0,0,0,0.1);">
            <h4 style="color:#185910;">Port Wajib Singgah</h4>
            <p>Lokasi strategik bersebelahan masjid & senang akses — sesuai untuk seisi keluarga.</p>
          </div>

        </div>
      </div>

      <!-- About Section -->
      <div id="about" style="padding: 80px 20px;  border-radius: 16px; margin-bottom: 40px;">
      <h2 style="text-align: center; font-size: 36px; color:rgb(0, 0, 0); font-family: 'Poppins', sans-serif; font-weight: bold;">Latar Belakang</h2>
      <p style="max-width: 700px; margin: 30px auto; text-align: center;">
          Warong Nasi Ambeng Bonda merupakan destinasi makanan tradisional Jawa yang terkenal di Masai, Johor, khususnya di kalangan pencinta nasi ambeng. Terletak di Jalan Bayan 45, Taman Megah Ria, bersebelahan Masjid Hajah Maznah, warung ini menawarkan pelbagai hidangan lazat dengan harga yang sangat berpatutan.
        </p>
      </div>

      <footer style="text-align: center; padding: 40px 20px; color: #999;">
        <p>&copy; 2025 Warong Nasi Ambeng Bonda | Jalan Bayan 45, Taman Megah Ria, Masai, Johor</p>
      </footer>
      
    </div>
  </div>

</section>

<style>

.hero-section h1{
          font-size: 40px;
          font-weight: bold !important;

        }

    @media (max-width: 767px) {
  .hero-section {
    padding: 60px 10px;
  }

  .hero-section h1 {
    font-size: 20px;
    font-weight: 200 !important;
    font-weight: bold !important;
    font-family: Poppins;

      
  }

  .hero-section p {
    font-size: 14px;
    max-width: 100%;
  }

  .menu-item {
    width: 100%;
    max-width:
  }
}

</style>



    <?php
// Include the database configuration file
include 'config.php';

// Start the session

// Check if the form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Retrieve user_id from session
    if(isset($_SESSION['user_id'])) {
        $user_id = $_SESSION['user_id'];
    } else {
        // Redirect the user or handle the absence of user_id in session
        exit("User not logged in.");
    }

    // Handling item addition to the cart
    if (isset($_POST['item_name']) && isset($_POST['item_price']) && isset($_POST['quantity']) && isset($_POST['item_image'])) {
        $item_name = $_POST['item_name'];
        $item_price = floatval(str_replace(['RM:', 'O'], '', $_POST['item_price']));
        $quantity = $_POST['quantity'];
        $item_image = $_POST['item_image'];

        // Calculate the subtotal
        $subtotal = $item_price * $quantity;

        // Check if the item already exists in the cart for the user
        $stmt = $conn->prepare("SELECT id, quantity FROM cart WHERE item_name = ? AND user_id = ?");
        $stmt->bind_param("si", $item_name, $user_id);
        $stmt->execute();
        $result = $stmt->get_result();
        
        // Check for errors
        if (!$result) {
            // Handle the SQL error
            exit("Error: " . $conn->error);
        }

        $stmt->close();

        if ($result->num_rows > 0) {
            // If the item exists in cart1, update the quantity and subtotal
            $row = $result->fetch_assoc();
            $new_quantity = $row['quantity'] + $quantity;
            $new_subtotal = $subtotal + ($row['quantity'] * $item_price);
        
            // Update the quantity and subtotal in cart1
            $stmt = $conn->prepare("UPDATE cart SET quantity = ?, subtotal = ? WHERE id = ?");
            $stmt->bind_param("idi", $new_quantity, $new_subtotal, $row['id']);
            $stmt->execute();

            // Check for errors
            if (!$stmt) {
                // Handle the SQL error
                exit("Error: " . $conn->error);
            }

            $stmt->close();
        } else {
            // If the item doesn't exist in cart1, add it to cart1 for the user
            $stmt = $conn->prepare("INSERT INTO cart (user_id, item_name, item_price, quantity, item_image, subtotal) VALUES (?, ?, ?, ?, ?, ?)");
            $stmt->bind_param("isdssi", $user_id, $item_name, $item_price, $quantity, $item_image, $subtotal);
            $stmt->execute();

            // Check for errors
            if (!$stmt) {
                // Handle the SQL error
                exit("Error: " . $conn->error);
            }

            $stmt->close();
            
            // Now, add the item to cart2 as well
            $stmt2 = $conn->prepare("INSERT INTO cart2 (user_id, item_name, item_price, quantity, item_image, subtotal, payment) VALUES (?, ?, ?, ?, ?, ?, ?)");
            // Set the payment status to 'payment not done'
            $payment_status = 'payment not done';
            $stmt2->bind_param("isdssis", $user_id, $item_name, $item_price, $quantity, $item_image, $subtotal, $payment_status);
            $stmt2->execute();

            // Check for errors
            if (!$stmt2) {
                // Handle the SQL error
                exit("Error: " . $conn->error);
            }

            $stmt2->close();
        }
        
    }
}
?>




<section id="person" class="content-section">
    <div class="profile-heading">
        <h2>User Profile</h2>
    </div>
    <?php
    // Start the session

    // Include the database configuration
    require_once 'config.php';

    // Check if user_id is provided in the session
    if(isset($_SESSION['user_id'])) {
        // Get the user_id from the session
        $user_id = $_SESSION['user_id'];

        // Sanitize the input to prevent SQL injection
        $user_id = mysqli_real_escape_string($conn, $user_id);

        // SQL query to retrieve data from user_info2 table based on user_id
        $sql = "SELECT name, phone FROM user_info WHERE user_id = '$user_id'";

        // Execute query
        $result = $conn->query($sql);

        // Check if there are results
        if ($result->num_rows > 0) {
            // Output data of each row
            while ($row = $result->fetch_assoc()) {
                ?>
                <div class="profile-data">
                    <label>Name:</label> <?php echo $row["name"]; ?>
                </div>
              
                <div class="profile-data">
                    <label>Phone:</label> <?php echo $row["phone"]; ?>
                </div>
                <?php
            }
        } else {
            echo "No results found for user_id: $user_id";
        }
    } else {
        echo "User ID is not provided in the session.";
    }

    // Close connection
    $conn->close();
    ?>
</section>



<section id="food" class="content-section">

<style>
    /* CSS for disabled add to cart button */
.menu-item-3 .add-to-cart-btn[disabled] {
    background-color: #ff0000; /* Change background color to red */
    color: #ffffff; /* Change text color to white */
    cursor: not-allowed;

}

.out-of-stock-overlay {
    position: absolute;
    top: 10px;
    left: 10px;
    background-color: rgba(255, 0, 0, 0.85);
    color: white;
    padding: 5px 10px;
    font-weight: bold;
    border-radius: 4px;
    z-index: 1;
}


</style>


    <h2 class="heading-menu">Aneka lauk</h2>

    <?php
// Include the database configuration file
include 'config.php';

// Query to fetch menu items from the database
$sql = "SELECT * FROM menu_items";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    // Output data of each row
    while ($row = $result->fetch_assoc()) {
        // Determine button status and text based on availability
        $button_status = $row["available"] ? "" : "disabled style='background-color: #ccc; cursor: not-allowed;'";
        $button_text = $row["available"]
            ? '<i class="fas fa-shopping-cart"></i> Add to Cart'
            : 'Out of Stock';
            
        // HTML code for displaying each menu item
        echo '<div class="menu-item-3" style="position: relative; ' . ($row["available"] ? '' : 'opacity: 0.5;') . '">';

        // Display product image
        echo '<img src="' . $row["image"] . '" alt="Food Image" style="width: 100%; height: auto;">';

        // Display 'Out of Stock' overlay if the item is unavailable
        if (!$row["available"]) {
            echo '<div class="out-of-stock-overlay">Out of Stock</div>';
        }

        // Display product details and add-to-cart form
        echo '<div class="menu-food">';
        echo '<h3>' . $row["name"] . '</h3>';
        echo '<p>RM:' . $row["price"] . '</p>';
        echo '<form class="add-to-cart-form-food" method="POST" ' . ($row["available"] ? '' : 'style="pointer-events: none;"') . '>';
        echo '<input type="hidden" name="item_name" value="' . $row["name"] . '">';
        echo '<input type="hidden" name="item_price" value="' . $row["price"] . '">';
        echo '<input type="hidden" name="item_image" value="' . $row["image"] . '">';

        echo '<div class="quantity-wrapper">';
        echo '<button type="button" class="qty-btn minus" ' . ($row["available"] ? '' : 'disabled') . '>−</button>';
        echo '<input type="number" name="quantity" class="qty-input" value="1" min="1" ' . ($row["available"] ? '' : 'disabled') . '>';
        echo '<button type="button" class="qty-btn plus" ' . ($row["available"] ? '' : 'disabled') . '>+</button>';
        echo '</div>';

        echo '<button type="submit" class="add-to-cart-btn" name="add_to_cart" ' . $button_status . '>' . $button_text . '</button>';
        echo '</form>';
        echo '</div>'; // Close menu-food
        echo '</div>'; // Close menu-item-3
    }
} else {
    echo "No items found in the menu.";
}

$conn->close();
?>

</section>



  <section id="drink" class="content-section">
  <h2 class="heading-menu">Minuman</h2>
  <?php
// Include the database configuration file
include 'config.php';

// Query to fetch drink items from the database
$sql = "SELECT * FROM drink_items";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $isAvailable = $row["available"];
        $button_status = $isAvailable ? "" : "disabled";
        $button_text = $isAvailable 
            ? '<i class="fas fa-shopping-cart"></i> Add to Cart' 
            : 'Out of Stock';

        echo '<div class="menu-item-3" style="position: relative; ' . (!$isAvailable ? 'opacity: 0.5;' : '') . '">';

        echo '<img src="' . $row["image"] . '" alt="Drink Image">';

        if (!$isAvailable) {
            echo '<div class="out-of-stock-overlay">Out of Stock</div>';
        }

        echo '<div class="menu-food">';
        echo '<h3>' . $row["name"] . '</h3>';
        echo '<p>RM: ' . $row["price"] . '</p>';
        echo '<form class="add-to-cart-form-food" method="POST" ' . ($isAvailable ? '' : 'style="pointer-events: none;"') . '>';
        echo '<input type="hidden" name="item_name" value="' . $row["name"] . '">';
        echo '<input type="hidden" name="item_price" value="' . $row["price"] . '">';
        echo '<input type="hidden" name="item_image" value="' . $row["image"] . '">';

        echo '<div class="quantity-wrapper">';
        echo '<button type="button" class="qty-btn minus" ' . ($isAvailable ? '' : 'disabled') . '>−</button>';
        echo '<input type="number" name="quantity" class="qty-input" value="1" min="1" ' . ($isAvailable ? '' : 'disabled') . '>';
        echo '<button type="button" class="qty-btn plus" ' . ($isAvailable ? '' : 'disabled') . '>+</button>';
        echo '</div>';

        echo '<button type="submit" class="add-to-cart-btn" name="add_to_cart" ' . $button_status . '>' . $button_text . '</button>';
        echo '</form>';
        echo '</div>'; // .menu-food
        echo '</div>'; // .menu-item-3
    }
} else {
    echo "No drinks found in the menu.";
}

$conn->close();
?>
    
</section>

<style>
  .menu-grid {
  display: flex;
  flex-wrap: wrap;
  justify-content: center; /* ✅ Center the items */
  gap: 20px;
  margin-top: 20px;
}

.heading-menu {
  text-align: center !important;
  font-family: Poppins, sans-serif;
  font-weight: bold;
}


</style>


<section id="pencuci-mulut" class="content-section">
<h2 class="heading-menu">Minuman</h2>

  <div class="menu-grid"> <!-- ✅ Add this wrapper to center cards -->
    <?php 
    include 'config.php';

    $sql = "SELECT * FROM pencuci_mulut";
    $result = $conn->query($sql);

    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $isAvailable = $row["available"];
            $button_status = $isAvailable ? "" : "disabled style='background-color: #ccc; cursor: not-allowed;'";
            $button_text = $isAvailable 
                ? '<i class="fas fa-shopping-cart"></i> Add to Cart'
                : 'Out of Stock';

            echo '<div class="menu-item-3" style="position: relative; ' . (!$isAvailable ? 'opacity: 0.5;' : '') . '">';
            echo '<img src="' . $row["image"] . '" alt="Food Image">';
            if (!$isAvailable) {
                echo '<div class="out-of-stock-overlay">Out of Stock</div>';
            }

            echo '<div class="menu-food">';
            echo '<h3>' . $row["name"] . '</h3>';
            echo '<p>RM: ' . $row["price"] . '</p>';

            echo '<form class="add-to-cart-form-food" method="POST" ' . ($isAvailable ? '' : 'style="pointer-events: none;"') . '>';
            echo '<input type="hidden" name="item_name" value="' . $row["name"] . '">';
            echo '<input type="hidden" name="item_price" value="' . $row["price"] . '">';
            echo '<input type="hidden" name="item_image" value="' . $row["image"] . '">';

            echo '<div class="quantity-wrapper">';
            echo '<button type="button" class="qty-btn minus" ' . ($isAvailable ? '' : 'disabled') . '>−</button>';
            echo '<input type="number" name="quantity" class="qty-input" value="1" min="1" ' . ($isAvailable ? '' : 'disabled') . '>';
            echo '<button type="button" class="qty-btn plus" ' . ($isAvailable ? '' : 'disabled') . '>+</button>';
            echo '</div>';

            echo '<button type="submit" class="add-to-cart-btn" name="add_to_cart" ' . $button_status . '>' . $button_text . '</button>';
            echo '</form>';

            echo '</div>'; // .menu-food
            echo '</div>'; // .menu-item-3
        }
    } else {
        echo "No items found in the menu.";
    }

    $conn->close();
    ?>
  </div> <!-- ✅ Close wrapper -->
</section>

<section id="set-nasi" class="content-section">
  <h2 class="heading-menu">Set Nasi & Lauk</h2>

  <div class="menu-grid"> <!-- Flex wrapper start -->

  <?php
  // Include the database configuration file
  include 'config.php';

  // Query to fetch menu items from set_nasi table
  $sql = "SELECT * FROM set_nasi";
  $result = $conn->query($sql);

  if ($result->num_rows > 0) {
      while ($row = $result->fetch_assoc()) {
          // Determine button status and text based on availability
          $button_status = $row["available"] ? "" : "disabled style='background-color: #ccc; cursor: not-allowed;'";
          $button_text = $row["available"]
              ? '<i class="fas fa-shopping-cart"></i> Add to Cart'
              : 'Out of Stock';

          echo '<div class="menu-item-3" style="position: relative; ' . ($row["available"] ? '' : 'opacity: 0.5;') . '">';

          // Image
          echo '<img src="' . $row["image"] . '" alt="Food Image" style="width: 100%; height: auto;">';

          // Overlay if out of stock
          if (!$row["available"]) {
              echo '<div class="out-of-stock-overlay">Out of Stock</div>';
          }

          echo '<div class="menu-food">';
          echo '<h3>' . $row["name"] . '</h3>';
          echo '<p>RM:' . $row["price"] . '</p>';

          // Form
          echo '<form class="add-to-cart-form-food" method="POST" ' . ($row["available"] ? '' : 'style="pointer-events: none;"') . '>';
          echo '<input type="hidden" name="item_name" value="' . $row["name"] . '">';
          echo '<input type="hidden" name="item_price" value="' . $row["price"] . '">';
          echo '<input type="hidden" name="item_image" value="' . $row["image"] . '">';

          // Quantity input
          echo '<div class="quantity-wrapper">';
          echo '<button type="button" class="qty-btn minus" ' . ($row["available"] ? '' : 'disabled') . '>−</button>';
          echo '<input type="number" name="quantity" class="qty-input" value="1" min="1" ' . ($row["available"] ? '' : 'disabled') . '>';
          echo '<button type="button" class="qty-btn plus" ' . ($row["available"] ? '' : 'disabled') . '>+</button>';
          echo '</div>';

          // Button
          echo '<button type="submit" class="add-to-cart-btn" name="add_to_cart" ' . $button_status . '>' . $button_text . '</button>';
          echo '</form>';

          echo '</div>'; // .menu-food
          echo '</div>'; // .menu-item-3
      }
  } else {
      echo "No items found in the menu.";
  }

  $conn->close();
  ?>

  </div> <!-- Flex wrapper end -->
</section>



<section id="masakan-panas" class="content-section">
  <h2 class="heading-menu">Masakan Panas</h2>

  <div class="menu-grid"> <!-- Flexbox wrapper -->

  <?php
  // Include the database configuration file
  include 'config.php';

  // Query to fetch menu items from the masakan_panas table
  $sql = "SELECT * FROM masakan_panas";
  $result = $conn->query($sql);

  if ($result->num_rows > 0) {
      while ($row = $result->fetch_assoc()) {
          $isAvailable = $row["available"];

          // Conditional styling and button state
          $button_status = $isAvailable ? "" : "disabled style='background-color: #ccc; cursor: not-allowed;'";
          $button_text = $isAvailable 
              ? '<i class="fas fa-shopping-cart"></i> Add to Cart'
              : 'Out of Stock';

          echo '<div class="menu-item-3" style="position: relative; ' . (!$isAvailable ? 'opacity: 0.5;' : '') . '">';

          // Menu image
          echo '<img src="' . $row["image"] . '" alt="Food Image" style="width: 100%; height: auto;">';

          // Overlay for unavailable items
          if (!$isAvailable) {
              echo '<div class="out-of-stock-overlay">Out of Stock</div>';
          }

          // Menu content
          echo '<div class="menu-food">';
          echo '<h3>' . $row["name"] . '</h3>';
          echo '<p>RM: ' . $row["price"] . '</p>';

          // Add to cart form
          echo '<form class="add-to-cart-form-food" method="POST" ' . ($isAvailable ? '' : 'style="pointer-events: none;"') . '>';
          echo '<input type="hidden" name="item_name" value="' . $row["name"] . '">';
          echo '<input type="hidden" name="item_price" value="' . $row["price"] . '">';
          echo '<input type="hidden" name="item_image" value="' . $row["image"] . '">';

          // Quantity input
          echo '<div class="quantity-wrapper">';
          echo '<button type="button" class="qty-btn minus" ' . ($isAvailable ? '' : 'disabled') . '>−</button>';
          echo '<input type="number" name="quantity" class="qty-input" value="1" min="1" ' . ($isAvailable ? '' : 'disabled') . '>';
          echo '<button type="button" class="qty-btn plus" ' . ($isAvailable ? '' : 'disabled') . '>+</button>';
          echo '</div>';

          // Submit button
          echo '<button type="submit" class="add-to-cart-btn" name="add_to_cart" ' . $button_status . '>' . $button_text . '</button>';
          echo '</form>';

          echo '</div>'; // .menu-food
          echo '</div>'; // .menu-item-3
      }
  } else {
      echo "No items found in the menu.";
  }

  $conn->close();
  ?>
  
  </div> <!-- Close menu-grid -->
</section>



<script>
document.querySelectorAll('.quantity-wrapper').forEach(wrapper => {
    const input = wrapper.querySelector('.qty-input');
    const plus = wrapper.querySelector('.plus');
    const minus = wrapper.querySelector('.minus');

    plus.addEventListener('click', () => {
        input.value = parseInt(input.value) + 1;
    });

    minus.addEventListener('click', () => {
        if (parseInt(input.value) > 1) {
            input.value = parseInt(input.value) - 1;
        }
    });
});
</script>


<style>
    .quantity-wrapper {
  display: flex;
  align-items: center;
  border: 1px solid #ccc;
  border-radius: 6px;
  overflow: hidden;
  width: fit-content;
  margin-bottom: 10px;
}

.qty-input {
  width: 50px;
  text-align: center;
  border: none;
  font-size: 16px;
  outline: none;
  appearance: textfield;
}

.qty-btn {
  background-color: #6e3b27;
  border: none;
  font-size: 20px;
  padding: 6px 10px;
  cursor: pointer;
}

.qty-btn:hover {
  background-color: #ccc;
}

.qty-input::-webkit-outer-spin-button,
.qty-input::-webkit-inner-spin-button {
  -webkit-appearance: none;
  margin: 0;
}

.qty-input[type=number] {
  -moz-appearance: textfield;
}

</style>

        

    <!-- Popup for successful addition to cart -->
<div id="success-popup" class="popup-modal" style="display: none;">
    <div class="popup-content">
        <span class="close-btn" onclick="closePopup()">&times;</span>
        <p>Item added to cart successfully!</p>
    </div>
</div>

<style>
  /* Popup modal background */
.popup-modal {
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background-color: rgba(0, 0, 0, 0.5); /* semi-transparent dark overlay */
  display: flex;
  justify-content: center;
  align-items: center;
  z-index: 1000;
}

/* Popup content box */
.popup-content {
  background-color: #28a745; /* green to indicate success */
  color: white;
  padding: 20px 30px;
  border-radius: 8px;
  box-shadow: 0 4px 10px rgba(0,0,0,0.3);
  max-width: 300px;
  width: 90%;
  text-align: center;
  font-family: Arial, sans-serif;
  position: relative;
}

/* Close button */
.close-btn {
  position: absolute;
  top: 8px;
  right: 12px;
  color: white;
  font-size: 24px;
  font-weight: bold;
  cursor: pointer;
  user-select: none;
  transition: color 0.3s ease;
}

.close-btn:hover {
  color: #ccc;
}

.popup-content p {
  font-family: 'Poppins', sans-serif;
  font-weight: 500; /* optional: controls thickness */
  font-size: 16px; /* adjust as needed */
  margin: 0;
}


</style>

<script>
    // Function to handle form submission and show success popup
    function handleFormSubmission(form) {
        // Retrieve the form data
        var formData = new FormData(form);

        // Send an AJAX request to the server
        var xhr = new XMLHttpRequest();
        xhr.open('POST', '<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>', true);
        xhr.onload = function () {
            if (xhr.status === 200) {
                // Show the success popup
                showSuccessPopup();
            }
        };
        xhr.send(formData);
    }

    // Function to show the success popup
    function showSuccessPopup() {
        var successPopup = document.getElementById('success-popup');
        successPopup.style.display = 'block';
        // Hide the popup after 2 seconds
        setTimeout(function() {
            successPopup.style.display = 'none';
        }, 2000);
    }

    // Attach event listeners to forms from food and drink menus
    document.querySelectorAll('.add-to-cart-form-food, .add-to-cart-form-drink').forEach(function(form) {
        form.addEventListener('submit', function(event) {
            // Prevent the default form submission behavior
            event.preventDefault();
            // Handle form submission
            handleFormSubmission(form);
        });
    });


    
</script>


<style>
 .checkout-button {
    display: block;           /* Make it a block-level element so width applies */
    width: 100%;              /* Full width of the container */
    max-width: 600px;         /* Optional: limit max width for better look on large screens */
    margin: 0 auto;           /* Center horizontally */
    padding: 10px 20px;
    background-color: #2d632d !important;
    color: #fff;
    text-decoration: none;
    border: none;
    border-radius: 5px;
    cursor: pointer;
    text-align: center;       /* Center text inside the button */
}

</style>


<section id="checkout" class="content-section">
<h2 class="heading-menu">Checkout</h2>
<!-- Checkout Content Goes Here -->
    <div id="checkout-content">
        <!-- Content of the checkout section will be dynamically loaded here -->
    </div>
    <!-- Place Order Button with Spinner -->
    <button onclick="showContentWithSpinner('placeorder')" class="checkout-button" id="placeorder-button">
        <span id="placeorder-text">Place Order</span>
        <span id="placeorder-spinner" class="spinner" style="display:none;"></span>
    </button>
</section>




 

<section id="cart" class="content-section">
 
    <h2 class="heading-menu">Shopping Cart</h2>

    <div id="cart-items" class="cart-items">
        <!-- Cart items will be dynamically loaded here -->
    </div>
    <!-- Checkout Button with Spinner -->
    <button onclick="showContentWithSpinner('checkout')" class="checkout-button" id="checkout-button">
        <span id="checkout-text">Checkout</span>
        <span id="checkout-spinner" class="spinner" style="display:none;"></span>
    </button>

    <style>
      .disabled {
    color: #aaa;
}
.checkout-button[disabled] {
    background-color: #ccc;
    border: none;
}


    </style>

    
</section>


<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
   var modal = document.getElementById("receiptModal");
var updatingEnabled = true; // Flag to control updates

// Function to fetch cart items and update the cart
function updateCart() {
    if (!updatingEnabled) return; // Check if updating is enabled
    $.ajax({
        url: 'fetch_cart_items.php', // URL to fetch cart items
        type: 'GET',
        dataType: 'html',
        success: function(response) {
            // Update the cart items
            $('#cart-items').html(response);
        },
        error: function(xhr, status, error) {
            console.error(xhr.responseText);
        }
    });
}


function updateCheckout() {
    if (!updatingEnabled) return;

    $.ajax({
        url: 'fetch_checkout_content.php',
        type: 'GET',
        dataType: 'html',
        success: function(response) {
            // Update the checkout content
            $('#checkout-content').html(response);

            const isCartEmpty = response.includes('Your cart is empty.');

            if (isCartEmpty) {
                // Disable checkout text
                $('#checkout-text').addClass('disabled').css({
                    'pointer-events': 'none',
                    'opacity': '0.5'
                }).attr('title', 'Cart is empty');

                // Disable Place Order button
                $('#placeorder-button').prop('disabled', true).css({
                    'opacity': '0.5',
                    'cursor': 'not-allowed'
                }).attr('title', 'Cart is empty');

                // Disable Checkout button
                $('#checkout-button').prop('disabled', true).css({
                    'opacity': '0.5',
                    'cursor': 'not-allowed'
                }).attr('title', 'Cart is empty');

            } else {
                // Re-enable all buttons if cart is not empty
                $('#checkout-text').removeClass('disabled').css({
                    'pointer-events': '',
                    'opacity': ''
                }).removeAttr('title');

                $('#placeorder-button').prop('disabled', false).css({
                    'opacity': '',
                    'cursor': ''
                }).removeAttr('title');

                $('#checkout-button').prop('disabled', false).css({
                    'opacity': '',
                    'cursor': ''
                }).removeAttr('title');
            }
        },
        error: function(xhr, status, error) {
            console.error(xhr.responseText);
        }
    });
}




// Update cart initially
updateCart();

// Update checkout content initially
updateCheckout();

// Set interval to update cart every 5 seconds
setInterval(updateCart, 5000);

// Set interval to update checkout every 5 seconds
setInterval(updateCheckout, 5000);



// When the user clicks the button to submit payment
$('#submitPayment').click(function() {
    // Disable updates
    updatingEnabled = false;    

    // Your existing code for submitting payment...

    // Update checkout after payment is submitted
    updateCheckout();

    // Enable updates after modal is closed
    $('#doneButton, .close').one('click', function() {
        updatingEnabled = true;
    });
});

// When the user clicks on <span> (x) or the "Done" button to close the modal
$('#doneButton, .close').click(function() {
    // Your existing code for closing the modal...

    // Update cart and checkout after modal is closed
    updateCart();
    updateCheckout();
});

</script>


<section id="placeorder" class="content-section">

<div class="container">
    <h2>Place Order</h2>
    <div id="placeorder">
        <!-- Content of the place order section will be dynamically loaded here -->
    </div>
</div>
</section>

<style>
        .spinner {
            position: fixed; /* Setting position to fixed */
            top: 50% !important; /* Adjust as needed */
            left: 45% !important; /* Adjust as needed */
           
            width: 50px;
            height: 50px;
            border: 4px solid rgba(0, 0, 0, 0.1);
            border-left-color:rgb(0, 0, 0) !important;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            to {
                transform: rotate(360deg);
            }
        }
    </style>

<script>
   function showContentWithSpinner(sectionId) {
    var buttonId = sectionId === 'checkout' ? 'checkout-button' : 'placeorder-button';
    var buttonTextId = sectionId === 'checkout' ? 'checkout-text' : 'placeorder-text';
    var spinnerId = sectionId === 'checkout' ? 'checkout-spinner' : 'placeorder-spinner';

    var buttonText = document.getElementById(buttonTextId);
    var spinner = document.getElementById(spinnerId);

    // Show spinner and hide text
    buttonText.style.display = "none";
    spinner.style.display = "inline-block";

    if(sectionId === 'placeorder') {
        // Only when placeorder button clicked, call reset_session.php via AJAX
        fetch('reset_session.php', { method: 'POST' })
        .then(response => response.text())
        .then(data => {
            alert(data);  // You can remove alert and update UI as needed
            showContent(sectionId); // Call your showContent function
        })
        .catch(error => {
            alert('Error: ' + error);
        })
        .finally(() => {
            buttonText.style.display = "inline-block";
            spinner.style.display = "none";
        });
    } else {
        // For checkout or other sections, just simulate loading
        setTimeout(function() {
            showContent(sectionId);
            buttonText.style.display = "inline-block";
            spinner.style.display = "none";
        }, 5000);
    }
}

function showContent(sectionId) {
    // Your existing logic to show content
}

</script>








<!-- JavaScript to load the content dynamically -->
<script>
    $(document).ready(function() {
        // Function to fetch and load the content of the "Place Order" section
        function loadPlaceOrderContent() {
            $.ajax({
                url: 'placeorder_content.php', // URL of the PHP script that generates the content
                type: 'GET', // Use GET method to retrieve data
                success: function(response) {
                    $('#placeorder').html(response); // Insert the response into the "Place Order" section
                },
                error: function(xhr, status, error) {
                    console.error(xhr.responseText);
                }
            });
        }

        // Call the function to load the content when the page loads
        loadPlaceOrderContent();

        // Automatically refresh the content every 30 seconds (adjust as needed)
        setInterval(loadPlaceOrderContent, 5000); // 30 seconds interval
    });
</script>




<section id="complete" class="content-section">
    <div id="complete-content">
    </div>
</section>
<section id="catering" class="content-section" style="padding: 60px 20px; background-color: #f9f9f9; border-radius: 16px;">
  <h2 style="text-align: center; font-size: 36px; color:rgb(0, 0, 0); font-family: 'Poppins', sans-serif; font-weight: bold;">Perkhidmatan Catering</h2>
  <p style="text-align: center; max-width: 700px; margin: 20px auto; font-size: 18px; color: #333;">
    Untuk tempahan catering, sila pilih salah satu pilihan hubungi di bawah:
  </p>
  <ul class="tm-footer-links" style="list-style: none; padding: 0; display: flex; flex-direction: column; align-items: center; gap: 15px;">
    <li style="width: 100%; max-width: 320px;">
      <a href="whatsapp://send?phone=+601139763070&text=Hye%20i%20am%20interested%20to%20know%20more%20about%20your%20services." style="display: block; padding: 15px; background-color: #6e3b27; color: white; text-decoration: none; border-radius: 8px; text-align: center; font-size: 18px; font-weight: bold;">
        +6011 3976 3070 (Naqiudin)
      </a>
    </li>
    <li style="width: 100%; max-width: 320px;">
      <a href="whatsapp://send?phone=+601119993457&text=Hye%20i%20am%20interested%20to%20know%20more%20about%20your%20services." style="display: block; padding: 15px; background-color: #6e3b27; color: white; text-decoration: none; border-radius: 8px; text-align: center; font-size: 18px; font-weight: bold;">
        +6011 1999 3457 (Asyikin)
      </a>
    </li>
    <li style="width: 100%; max-width: 320px;">
      <a href="whatsapp://send?phone=+60137601224&text=Hye%20i%20am%20interested%20to%20know%20more%20about%20your%20services." style="display: block; padding: 15px; background-color: #6e3b27; color: white; text-decoration: none; border-radius: 8px; text-align: center; font-size: 18px; font-weight: bold;">
        +6013 7601 224 (Rohani Sabtu)
      </a>
    </li>
  </ul>

  <style>
    /* Mobile-first styles (default) */
.tm-footer-links {
  display: flex;
  flex-direction: column;
  align-items: center;
  gap: 15px;
}

.tm-footer-links li {
  width: 100%;
  max-width: 320px;
}

.tm-footer-links a {
  display: block;
  padding: 15px;
  background-color: #25d366;
  color: white;
  text-decoration: none;
  border-radius: 8px;
  text-align: center;
  font-size: 18px;
  font-weight: bold;
}

/* Tablet and larger screens */
@media (min-width: 768px) {
  .tm-footer-links {
    flex-direction: row;
    justify-content: center;
  }

  .tm-footer-links li {
    width: 33%;
    max-width: none;
  }
}

  </style>
</section>





c
    </div>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
    $(document).ready(function() {
        // Function to fetch complete section content and update the section
        function updateCompleteSection() {
            $.ajax({
                url: 'fetch_complete_content.php', // URL to fetch complete section content
                type: 'GET',
                dataType: 'html',
                success: function(response) {
                    // Update the complete section content
                    $('#complete-content').html(response);
                },
                error: function(xhr, status, error) {
                    console.error(xhr.responseText);
                }
            });
        }

        // Update complete section initially
        updateCompleteSection();

        // Set interval to periodically update the complete section every 5 seconds (5000 milliseconds)
        setInterval(updateCompleteSection, 5000);
    });
</script>


<style>
    .footer-columns {
    display: flex;
    justify-content: space-around;
    flex-wrap: nowrap;
}
</style>
<script>
    function toggleTerms() {
        var expandedTerms = document.getElementById("expanded-terms");
        if (expandedTerms.style.display === "none") {
            expandedTerms.style.display = "block";
        } else {
            expandedTerms.style.display = "none";
        }
    }
</script>


    
    <script>
        function showContent(sectionId) {
            var contentSections = document.getElementsByClassName('content-section');
    
            for (var i = 0; i < contentSections.length; i++) {
                contentSections[i].style.display = 'none';
            }
    
            var selectedSection = document.getElementById(sectionId);
    
            if (selectedSection) {
                selectedSection.style.display = 'block';
                // Store the current section in local storage
                storeCurrentSection(sectionId);
            }
        }
    
        function showHomeSection() {
            showContent('home');
        }
    
        function storeCurrentSection(sectionId) {
            localStorage.setItem('currentSection', sectionId);
        }
    
        window.onload = function() {
            // Retrieve the current section from local storage
            var currentSection = localStorage.getItem('currentSection');
            
            // If there is a current section stored, show it
            if (currentSection) {
                showContent(currentSection);
            } else {
                // Otherwise, show the default section (e.g., "Home")
                showHomeSection();
            }
        };
  
    </script>


<script>
  const isDev = true; // change to false in production

if (!isDev) {
    setInterval(refreshCartCount, 5000);
    setInterval(updateCart, 5000);
    setInterval(updateCheckout, 5000);
    setInterval(loadPlaceOrderContent, 5000);
    setInterval(updateCompleteSection, 5000);
}

</script>


</body>


</html>
