<?php
session_start();
include 'config.php';

$user_id = $_SESSION['user_id'] ?? null;
$totalItems = 0;

if ($user_id) {
    $cartCountQuery = "SELECT SUM(quantity) AS total_items FROM cart WHERE user_id = ?";
    $stmt = $conn->prepare($cartCountQuery);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $totalItems = $row['total_items'] ?? 0;
    }

    $stmt->close();
}

echo $totalItems;
?>
