<?php
// Include the database configuration file
include 'config.php';

// Check if the user is logged in and user_id is available in the session
if (isset($_SESSION['user_id'])) {
    $user_id = $_SESSION['user_id'];

    // Query to retrieve payment method for the user
    $sql = "SELECT method FROM payment_method WHERE user_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        // Store payment method(s) in an array
        $payment_methods = array();
        while ($row = $result->fetch_assoc()) {
            $payment_methods[] = $row['method'];
        }
        
        // Send payment method(s) as JSON response
        echo json_encode($payment_methods);
    } else {
        // If no payment method found, send empty response
        echo json_encode([]);
    }
} else {
    // If user_id not found in session, send empty response
    echo json_encode([]);
}
?>
