<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Complete Cart Items</title>
    <style>
        /* CSS for styling the complete section content */
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
        }

        /* Style for the container div */
        .container {
            max-width: 800px;
            margin: 20px auto;
            padding: 20px;
            background-color: #fff;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            border-radius: 5px;
        }

        /* Style for each item container */
        .item-container {
            border: 1px solid #ccc;
            margin-bottom: 20px;
            padding: 10px;
            background-color: #f9f9f9;
        }

        /* Style for item name */
        .item-name {
            font-weight: bold;
            margin: 0;
        }

        /* Style for item price */
        .item-price {
            margin: 0;
            color: #333;
        }

        /* Style for item quantity */
        .item-quantity {
            margin: 0;
            color: #666;
        }

        /* Style for item image */
        .item-image {
            max-width: 100%;
            height: auto;
            margin-top: 10px;
            display: block;
        }

        /* Media query for responsiveness */
        @media screen and (max-width: 600px) {
            .container {
                padding: 10px;
            }
            .item-container {
                padding: 5px;
            }
        }
    </style>
</head>
<body>

<div class="container">
    <h1>Complete Cart Items</h1>

    <?php
    // Include the database configuration file
    include 'config.php';

    // Start the session
    session_start();

    // Check if the user is logged in
    if (!isset($_SESSION['user_id'])) {
        // Redirect the user or handle the absence of user_id in session
        echo "User not logged in.";
        exit();
    }

    // Retrieve user_id from session
    $user_id = $_SESSION['user_id'];

    // Prepare and execute SQL query to fetch data for the complete section
    $stmt = $conn->prepare("SELECT * FROM cart2 WHERE user_id = ? AND payment = 'payment done'");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();

    // Check if there are any rows returned
    if ($result->num_rows > 0) {
        // Loop through each row and display item details
        while ($row = $result->fetch_assoc()) {
            echo '<div class="item-container">';
            echo '<p class="item-name">Item: ' . $row['item_name'] . '</p>';
            echo '<p class="item-price">Price: RM ' . $row['item_price'] . '</p>';
            echo '<p class="item-quantity">Quantity: ' . $row['quantity'] . '</p>';
            echo '<img class="item-image" src="' . $row['item_image'] . '" alt="' . $row['item_name'] . '">';
            echo '</div>';
        }
    } else {
        // If no items found, display a message
        echo 'No items found in the cart.';
    }

    // Close the statement
    $stmt->close();
    ?>

</div>

</body>
</html>
