<?php
// Start the session
session_start();

// Include the database configuration file
include 'config.php';

// Initialize total price variable
$totalPrice = 0;

// Check if the user is logged in and user_id is available in the session
if(isset($_SESSION['user_id'])) {
    $user_id = $_SESSION['user_id'];

    // Retrieve user information from the database
    $sql_user = "SELECT name, phone FROM user_info WHERE user_id = ?";
    $stmt_user = $conn->prepare($sql_user);
    $stmt_user->bind_param("i", $user_id);
    $stmt_user->execute();
    $result_user = $stmt_user->get_result();

    // Check if user information is found
    if ($result_user->num_rows > 0) {
        // Fetch user information
        $user_info = $result_user->fetch_assoc();
        $username = $user_info['name'];
        $phone = $user_info['phone'];

        echo "<p style='font-weight: bold; color: #333;'>Name: $username</p>";
        echo "<p style='color: #555;'>Phone: $phone</p>";

        
        // Retrieve cart items for the specific user from the database
        $sql_cart = "SELECT item_name, item_price, quantity, item_image, time_added FROM cart WHERE user_id = ?";
        $stmt_cart = $conn->prepare($sql_cart);
        $stmt_cart->bind_param("i", $user_id);
        $stmt_cart->execute();
        $result_cart = $stmt_cart->get_result();

        // Check if there are items in the cart
        if ($result_cart->num_rows > 0) {
            // Display cart items
            while ($row = $result_cart->fetch_assoc()) {
                // Calculate subtotal for each item
                $subtotal = $row['item_price'] * $row['quantity'];
                $totalPrice += $subtotal; // Add subtotal to total price
                ?>
                <div class="cart-item">
                    <div class="item-image">
                        <img src="<?php echo $row['item_image']; ?>" alt="Item Image">
                    </div>
                    <div class="item-details">
                        <p>Name: <?php echo $row['item_name']; ?></p>
                        <p>Price: <?php echo $row['item_price']; ?></p>
                        <p>Quantity: <?php echo $row['quantity']; ?></p>
                        <p>Added Time: <?php echo $row['time_added']; ?></p>
                        <p>Subtotal: <?php echo $subtotal; ?></p>
                    </div>
                </div>
                <?php
            }
            // Display total price after all items are listed
            echo "<p>Total Price: $totalPrice</p>";
        } else {
            // If cart is empty for the user
            echo "<p>Your cart is empty.</p>";
        }
    } else {
        // If user information is not found
        echo "<p>User information not found.</p>";
    }
} else {
    // If user is not logged in or user_id is not available in session
    echo '<p>User ID is not available or user is not logged in. Please log in to continue.</p>';
}
?>

<style>
    /* Style to display radio buttons and labels inline */
    .payment-option {
        display: inline-block;
        margin-right: 10px; /* Adjust as needed */
    }
     .payment-notice {
        font-weight: bold;
    }
</style>

<div>
    <!-- Radio button for Cash -->
    <div class="payment-option">    
        <input type="radio" id="cash" name="paymentMethod" value="cash">
        <label for="cash">Cash</label>
    </div>
    
    <!-- Radio button for QR Code -->
    <div class="payment-option">
        <input type="radio" id="qr_code" name="paymentMethod" value="qr_code"> 
        <label for="qr_code">QR Code</label>
    </div>

    <!-- Notice for paying at the counter -->
    <div class="payment-notice">
        Please pay at the counter.
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
function handlePaymentSelection() {
    var paymentMethod = this.value;

    sessionStorage.setItem('paymentMethod', paymentMethod);

    $.ajax({
        url: "update_payment.php",
        type: "POST",
        data: {
            paymentMethod: paymentMethod
        },
        success: function(response) {
            console.log(response);
        },
        error: function(xhr, status, error) {
            console.error(error);
        }
    });
}

// Set previously stored values
$(document).ready(function() {
    var storedPaymentMethod = sessionStorage.getItem('paymentMethod');

    if (storedPaymentMethod) {
        $('input[value="' + storedPaymentMethod + '"]').prop('checked', true);
    }

    $('input[name="paymentMethod"]').change(handlePaymentSelection);
});
</script>




</div>


