<?php
// Include the database configuration file
include 'config.php';

// Check if the date parameter is set in the URL
if(isset($_GET['date'])) {
    // Get the date parameter value
    $date = $_GET['date'];

    // Query to fetch total sales for the specified date
    $stmt_sales = $conn->prepare("SELECT SUM(subtotal) AS total_sales FROM cart2 WHERE DATE(created_at) = ?");
    $stmt_sales->bind_param("s", $date);
    $stmt_sales->execute();
    $result_sales = $stmt_sales->get_result();

    // Fetch total sales
    $row_sales = $result_sales->fetch_assoc();
    $totalSales = $row_sales['total_sales'];

    // Display total sales for the specified date
    echo "<div id='totalSales' class='content-section'>";
    echo "<h2 style='font-size: 24px; margin-bottom: 10px;'>Total Sales for $date</h2>";
    echo "<p style='font-size: 18px; margin-bottom: 5px;'>RM " . $totalSales . "</p>";
    echo "</div>";

    // Close the statement
    $stmt_sales->close();
} else {
    // If date parameter is not set, display an error message
    echo "Error: Date parameter is missing.";
}

// Close the database connection
$conn->close();
?>
