<?php
session_start();
include 'config.php';

if (!isset($_SESSION['user_id'])) {
    echo 'User not logged in';
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['item_name'])) {
    $user_id = $_SESSION['user_id'];
    $item_name = $_POST['item_name'];

    $sql = "DELETE FROM cart WHERE user_id = ? AND item_name = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("is", $user_id, $item_name);
    if ($stmt->execute()) {
        echo "Item deleted successfully";
    } else {
        echo "Error deleting item";
    }
    $stmt->close();
    $conn->close();
} else {
    echo "Invalid request";
}
?>
