<?php
require 'config.php'; // Your DB connection file

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $order_number = isset($_POST['order_number']) ? trim($_POST['order_number']) : '';

    if (empty($order_number)) {
        echo '<p style="color:red;">Sila masukkan nombor pesanan.</p>';
        exit;
    }

    // Prepare and execute query to fetch order items
    $stmt = $conn->prepare("SELECT item_name, item_price, quantity, created_at FROM cart2 WHERE order_number = ?");
    $stmt->bind_param("s", $order_number);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        // Start output
        echo '<h3>Butiran Pesanan #: ' . htmlspecialchars($order_number) . '</h3>';
        echo '<table style="width:100%; border-collapse: collapse; font-family: Arial, sans-serif;">';
        echo '<thead>';
        echo '<tr style="background-color:#f2f2f2;">';
        echo '<th style="border: 1px solid #ddd; padding: 8px; text-align:left;">Nama Item</th>';
        echo '<th style="border: 1px solid #ddd; padding: 8px; text-align:right;">Harga (RM)</th>';
        echo '<th style="border: 1px solid #ddd; padding: 8px; text-align:center;">Kuantiti</th>';
        echo '<th style="border: 1px solid #ddd; padding: 8px; text-align:left;">Tarikh Pesanan</th>';
        echo '<th style="border: 1px solid #ddd; padding: 8px; text-align:right;">Subtotal (RM)</th>';
        echo '</tr>';
        echo '</thead>';
        echo '<tbody>';

        $total = 0;

        while ($row = $result->fetch_assoc()) {
            $subtotal = $row['item_price'] * $row['quantity'];
            $total += $subtotal;

            echo '<tr>';
            echo '<td style="border: 1px solid #ddd; padding: 8px;">' . htmlspecialchars($row['item_name']) . '</td>';
            echo '<td style="border: 1px solid #ddd; padding: 8px; text-align:right;">' . number_format($row['item_price'], 2) . '</td>';
            echo '<td style="border: 1px solid #ddd; padding: 8px; text-align:center;">' . intval($row['quantity']) . '</td>';
            echo '<td style="border: 1px solid #ddd; padding: 8px;">' . htmlspecialchars($row['created_at']) . '</td>';
            echo '<td style="border: 1px solid #ddd; padding: 8px; text-align:right;">' . number_format($subtotal, 2) . '</td>';
            echo '</tr>';
        }

        echo '<tr style="font-weight:bold; background-color:#f9f9f9;">';
        echo '<td colspan="4" style="border: 1px solid #ddd; padding: 8px; text-align:right;">Jumlah</td>';
        echo '<td style="border: 1px solid #ddd; padding: 8px; text-align:right;">RM ' . number_format($total, 2) . '</td>';
        echo '</tr>';

        echo '</tbody>';
        echo '</table>';
    } else {
        echo '<p>Tiada pesanan ditemui dengan nombor pesanan tersebut.</p>';
    }

    $stmt->close();
    $conn->close();
} else {
    echo '<p>Permintaan tidak sah.</p>';
}
?>
<style>
    table {
        width: 100%;
        border-collapse: collapse;
        font-family: Arial, sans-serif;
        background-color: #fff;
    }

    th, td {
        border: 1px solid #ddd;
        padding: 8px;
    }

    th {
        background-color: #f2f2f2;
        text-align: left;
    }

    tr:nth-child(even) {
        background-color: #f9f9f9;
    }

    tr:hover {
        background-color: #f1f1f1;
    }

    h3 {
        font-family: Arial, sans-serif;
        font-size: 20px;
        margin-top: 20px;
        color: #333;
    }

    p {
        font-family: Arial, sans-serif;
        font-size: 16px;
        color: #333;
    }
</style>
