// JavaScript to navigate to sections in the main part of the HTML document

// Function to show a specific section by its ID
function showSection(sectionId) {
    // Hide all sections
    var sections = document.querySelectorAll('.content-section');
    sections.forEach(function(section) {
        section.style.display = 'none';
    });

    // Show the section with the provided ID
    var sectionToShow = document.getElementById(sectionId);
    if (sectionToShow) {
        sectionToShow.style.display = 'block';
    }
}

// Function to redirect to home section
function redirectToHome() {
    showSection('Delivery'); // Change 'Delivery' to the section you want to redirect to
}

// Attach click event listeners to navigation links to show respective sections
document.addEventListener('DOMContentLoaded', function() {
    // Get all navigation links
    var navLinks = document.querySelectorAll('nav a');
    navLinks.forEach(function(link) {
        link.addEventListener('click', function(event) {
            event.preventDefault(); // Prevent default link behavior
            var sectionId = link.getAttribute('onclick').match(/'([^']+)'/)[1];
            showSection(sectionId);
        });
    });

    // Initially redirect to home section
    redirectToHome();
});

// You can also call redirectToHome() function after successful login
// For example, after the user successfully logs in, you can call:
// redirectToHome();



$(document).ready(function() {
    // Load the content of delivery.html into the delivery-content div
    $("#delivery-content").load("delivery.html");
});




document.addEventListener("DOMContentLoaded", function() {
    // Get references to DOM elements
    var swipeLeftButton = document.getElementById("swipeLeft");
    var swipeRightButton = document.getElementById("swipeRight");
    var imageContainer = document.querySelector(".image-container");

    // Set initial index and image width
    var currentIndex = 0;
    var imageWidth = imageContainer.clientWidth;

    // Function to handle swiping left
    function swipeLeft() {
        if (currentIndex > 0) {
            currentIndex--;
            imageContainer.style.transform = "translateX(-" + (currentIndex * imageWidth) + "px)";
        }
    }

    // Function to handle swiping right
    function swipeRight() {
        if (currentIndex < imageContainer.children.length - 1) {
            currentIndex++;
            imageContainer.style.transform = "translateX(-" + (currentIndex * imageWidth) + "px)";
        }
    }

    // Add event listeners to swipe buttons
    swipeLeftButton.addEventListener("click", swipeLeft);
    swipeRightButton.addEventListener("click", swipeRight);
});
