



<!DOCTYPE html>
<html lang="en">
    
<?php
// Include config.php
require_once 'config.php';

// Start session
session_start();

// Initialize error variable
$error = "";

// Handle registration form submission
if (isset($_POST['register'])) {
    // Validate form data
    $name = $_POST['name'];
    $email = $_POST['email'];
    $password = $_POST['password'];
    
    // Hash the password
    $hashed_password = password_hash($password, PASSWORD_DEFAULT);
    
    // Prepare and bind parameters for the INSERT statement
    $insert_sql = "INSERT INTO adminhost (name, email, password) VALUES (?, ?, ?)";
    $stmt = $conn->prepare($insert_sql);
    $stmt->bind_param("sss", $name, $email, $hashed_password);
    
    // Execute the statement
    if ($stmt->execute()) {
        // Registration successful, redirect to login page or desired page
        header("Location: login.php");
        exit();
    } else {
        // Error occurred
        $error = "Registration failed. Please try again later.";
    }
    
    // Close statement
    $stmt->close();
    
    // Close connection
    $conn->close();
}
?>
<head>
	<meta charset="utf-8">
	<title>Form-v6 by Colorlib</title>
	<!-- Mobile Specific Metas -->
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
	<!-- Font-->
	<link rel="stylesheet" type="text/css" href="css/nunito-font.css">
	<!-- Main Style Css -->
    <link rel="stylesheet" href="css/style.css"/>

<style>
    #bg-video {
    width: 100%; /* Set the width to 50% of its container */
    /* You can also specify specific width and height values */
    /* width: 400px; */
    /* height: 300px; */
}

</style>
   
</head>


<body class="form-v6">
	<div class="page-content">
		<div class="form-v6-content">


	<div class="form-left">
      <video autoplay muted loop id="bg-video">
        <source src="mp3.mp4" type="video/mp4">
        <!-- Add additional source elements for different video formats if needed -->
        Your browser does not support the video tag.
    </video>
</div>



<div class="form-detail">
    <h2>Register an Account</h2>
     <form method="post">
        <h1>Create Account</h1>
        <input type="text" name="name" placeholder="Name" required />
        <input type="email" name="email" placeholder="Email" required />
        <input type="password" name="password" placeholder="Password" required />

        <button type="submit" name="register">Sign Up</button>
    </form>
</div>




    <script>
        function startOrder() {
            // Show the spinner
            document.getElementById('spinner').style.display = 'block';
            
            // Redirect to the order page after a delay
            setTimeout(function() {
                // Assuming you want to submit the form data to another page
                document.getElementById('userInfoForm').submit();
            }, 2000); // Adjust the delay time as needed (in milliseconds)
        }
    </script>

 
</body>
</html>
