<?php
// Start session to access session variables
session_start();

// Retrieve the user_id from the session
$user_id = $_SESSION['user_id'];

// Check if user_id is set
if(isset($user_id)) {
    // Display the user_id
    echo "User ID: $user_id";
} else {
    // If user_id is not set, display a message
    echo "User ID not available";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Your Website</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <script src="https://maps.googleapis.com/maps/api/js?key=YOUR_API_KEY&callback=initMap" async defer></script>
    <link href="https://fonts.googleapis.com/css2?family=Pacifico&display=swap" rel="stylesheet">
    <script src="https://js.stripe.com/v3/"></script>
    <link rel="stylesheet" href="path/to/vendorlane.min.css">
    <script src="path/to/vendorlane.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/hammerjs"></script>




    <link rel="stylesheet" href="A.css">
    <script src="anggun.js"></script>

</head>
<body>
    <header class="header">
        <img src="23.png" alt="Your Logo" style="width: 200px;">
        <nav>
            <ul>
                <li><a href="#" onclick="showContent('person')"><i class="fas fa-user"></i> Person</a></li>
                <li><a href="#" onclick="showContent('cart')"><i class="fas fa-shopping-cart"></i> cart</a></li>
                <li><a href="#" onclick="showContent('contact')"><i class="fas fa-heart"></i> Contact</a></li>

            </ul>
        </nav>
   

        <script>
            // Retrieve user details from session storage
            var username = sessionStorage.getItem('username');
            var phone = sessionStorage.getItem('phone');
            var studentID = sessionStorage.getItem('studentID');
        
            // Update HTML content with user details
            document.getElementById('displayUsername').textContent = username;
            document.getElementById('displayPhone').textContent = phone;
            document.getElementById('displayStudentID').textContent = studentID;
        </script>
            
    </header>
    <nav class="top-nav">
        <ul class="icon-list">
            <li><a href="#" onclick="showContent('home')"><i class="fas fa-home"></i> Home</a></li>
            <li><a href="#" onclick="showContent('food')"><i class="fas fa-utensils"></i> Food</a></li>

            <li><a href="#" onclick="showContent('drink')"><i class="fas fa-cocktail"></i> Drink</a></li>
            <li><a href="#" onclick="showContent('Catering')"><i class="fas fa-utensils"></i> Catering</a></li>
        </ul>
    </nav>

    <div class="sidenav">
        <div class="container-2">
            <h3>Search for Food</h3>
            <div class="search-wrapper">
                <input type="text" id="searchInput" placeholder="Search for food...">
                <button onclick="searchFood()">Search</button>
    
                <div class="food-types">
                    <label><input type="checkbox" name="foodType" value="italian"> Italian</label>
                    <label><input type="checkbox" name="foodType" value="mexican"> Mexican</label>
                    <label><input type="checkbox" name="foodType" value="chinese"> Chinese</label>
                    <label><input type="checkbox" name="foodType" value="japanese"> Japanese</label>
                    <label><input type="checkbox" name="foodType" value="indian"> Indian</label>
                    <!-- Add more checkboxes for other food types -->
                </div>
            </div>
        </div>
    
        <!-- Offer Section -->
        <div class="container-2 offer-section">
            <h3>Special Offer</h3>
            <p>Enjoy Free Shipping on all orders!</p>
            <p>Use voucher code <strong>SHIPFREE</strong> at checkout.</p>
        </div>
    
 
             
        </div>
       
    </div>
    
    
    
    
    
   <div class="main">

   <section id="home" class="content-section">
        <div class="vendor-lane" id="vendorLane">
        

            <div class="image-container" >
                <img src="A2.jpeg" alt="Image Description">
                <img src="A3.jpeg" alt="Image Description">
                <img src="A4.jpeg" alt="Image Description">
                <img src="A6.jpeg" alt="Image Description">
                <img src="A7.jpeg" alt="Image Description">


      
            </div>
            
            <button id="swipeLeft" type="button">&lt;</button>
            <button id="swipeRight" type="button">&gt;</button>
      </div>

      <script>
        const container = document.querySelector('.image-container');
          const images = document.querySelectorAll('.image-container img');
          const swipeLeft = document.getElementById('swipeLeft');
          const swipeRight = document.getElementById('swipeRight');
          let counter = 0;
          const imageWidth = images[0].clientWidth;
      
          // Set initial position
          container.style.transform = `translateX(${-imageWidth * counter}px)`;
      
          swipeLeft.addEventListener('click', () => {
              counter--;
              if (counter < 0) {
                  counter = images.length - 1;
              }
              container.style.transform = `translateX(${-imageWidth * counter}px)`;
          });
      
          swipeRight.addEventListener('click', () => {
              counter++;
              if (counter >= images.length) {
                  counter = 0;
              }
              container.style.transform = `translateX(${-imageWidth * counter}px)`;
          });
      </script>
      

    </section>
    



    <?php
// Include the database configuration file
include 'config.php';

// Handling item addition to the cart
if (isset($_POST['item_name']) && isset($_POST['item_price']) && isset($_POST['quantity']) && isset($_POST['item_image'])) {
    $item_name = $_POST['item_name'];
    $item_price = floatval(str_replace(['RM:', 'O'], '', $_POST['item_price']));
    $quantity = $_POST['quantity'];
    $item_image = $_POST['item_image'];
    
    // Calculate the subtotal
    $subtotal = $item_price * $quantity;

    // Check if the item already exists in the cart
    $stmt = $conn->prepare("SELECT id, quantity FROM cart WHERE item_name = ?");
    $stmt->bind_param("s", $item_name);
    $stmt->execute();
    $result = $stmt->get_result();
    $stmt->close();

    if ($result->num_rows > 0) {
        // If the item exists, update the quantity and subtotal
        $row = $result->fetch_assoc();
        $new_quantity = $row['quantity'] + $quantity;
        $new_subtotal = $subtotal + ($row['quantity'] * $item_price);

        // Update the quantity and subtotal in the cart
        $stmt = $conn->prepare("UPDATE cart SET quantity = ?, subtotal = ? WHERE id = ?");
        $stmt->bind_param("idi", $new_quantity, $new_subtotal, $row['id']);
        $stmt->execute();
        $stmt->close();
    } else {
        // If the item doesn't exist, add it to the cart
        $stmt = $conn->prepare("INSERT INTO cart (item_name, item_price, quantity, item_image, subtotal) VALUES (?, ?, ?, ?, ?)");
        $stmt->bind_param("sdssi", $item_name, $item_price, $quantity, $item_image, $subtotal);
        $stmt->execute();
        $stmt->close();
    }
    }
    ?>

    <section id="food" class="content-section">

     
        <h2>Welcome to the Food Section</h2>
        <p>Explore our delicious food options here.</p>


        <div class="menu-item-3">
    <img src="m1.png" alt="Food Image 1">
    <div class="menu-food">
        <h3>Ayam Goreng</h3>
        <p>RM:4.OO</p>
        <!-- Form for adding items to the cart -->
        <form class="add-to-cart-form-food" method="POST">
            <!-- Hidden input fields for item details -->
            <input type="hidden" name="item_name" value="Ayam Goreng">
            <input type="hidden" name="item_price" value="4.OO">
            <!-- Input field for quantity -->
            <input type="number" name="quantity" value="1">
            <!-- Hidden input field for image source -->
            <input type="hidden" name="item_image" value="m1.png">
            <!-- Submit button to add item to cart -->
            <button type="submit" class="add-to-cart-btn" name="add_to_cart">Add to Cart</button>
        </form>
    </div>
</div>

<div class="menu-item-3">
    <img src="m2.png" alt="Food Image 2">
    <div class="menu-food">
        <h3>Ayam black paper</h3>
        <p>RM:4.OO</p>
        <!-- Form for adding items to the cart -->
        <form class="add-to-cart-form-food" method="POST">
            <!-- Hidden input fields for item name and price -->
            <input type="hidden" name="item_name" value="Ayam black paper">
            <input type="hidden" name="item_price" value="4.OO">
            <!-- Input field for quantity -->
            <input type="number" name="quantity" value="1">
            <!-- Submit button to add item to cart -->
            <input type="hidden" name="item_image" value="m2.png">

            <button type="submit" class="add-to-cart-btn" name="add_to_cart">Add to Cart</button>
        </form>
    </div>
</div>
<!-- Repeat the structure for other menu items -->



<div class="menu-item-3">
    <img src="m3.png" alt="Food Image 2">
    <div class="menu-food">
        <h3>Ayam cili padi</h3>
        <p>RM:4.OO</p>
        <!-- Form for adding items to the cart -->
        <form class="add-to-cart-form-food" method="POST">
            <!-- Hidden input fields for item name and price -->
            <input type="hidden" name="item_name" value="Ayam cili padi">
            <input type="hidden" name="item_price" value="4.OO">
            <!-- Input field for quantity -->
            <input type="number" name="quantity" value="1">
            <input type="hidden" name="item_image" value="m3.png">

            <!-- Submit button to add item to cart -->
            <button type="submit" class="add-to-cart-btn" name="add_to_cart">Add to Cart</button>
        </form>
    </div>
</div>


        

<div class="menu-item-3">
    <img src="m4.png" alt="Food Image 2">
    <div class="menu-food">
        <h3>Keli cili padi</h3>
        <p>RM:4.OO</p>
        <!-- Form for adding items to the cart -->
        <form class="add-to-cart-form-food" method="POST">
            <!-- Hidden input fields for item name and price -->
            <input type="hidden" name="item_name" value="Keli cili padi">
            <input type="hidden" name="item_price" value="4.OO">
            <!-- Input field for quantity -->
            <input type="number" name="quantity" value="1">
            <input type="hidden" name="item_image" value="m4.png">

            <!-- Submit button to add item to cart -->
            <button type="submit" class="add-to-cart-btn" name="add_to_cart">Add to Cart</button>
        </form>
    </div>
</div>





<div class="menu-item-3">
    <img src="m5.png" alt="Food Image 2">
    <div class="menu-food">
        <h3>Ayam asam pedas</h3>
        <p>RM:4.OO</p>
        <!-- Form for adding items to the cart -->
        <form class="add-to-cart-form-food" method="POST">
            <!-- Hidden input fields for item name and price -->
            <input type="hidden" name="item_name" value="Ayam asam pedas">
            <input type="hidden" name="item_price" value="4.OO">
            <!-- Input field for quantity -->
            <input type="number" name="quantity" value="1">
            <input type="hidden" name="item_image" value="m5.png">

            <!-- Submit button to add item to cart -->
            <button type="submit" class="add-to-cart-btn" name="add_to_cart">Add to Cart</button>
        </form>
    </div>
</div>


        
<div class="menu-item-3">
    <img src="m6.png" alt="Food Image 2">
    <div class="menu-food">
        <h3>Ayam masak kicap</h3>
        <p>RM:4.OO</p>
        <!-- Form for adding items to the cart -->
        <form class="add-to-cart-form-food" method="POST">
            <!-- Hidden input fields for item name and price -->
            <input type="hidden" name="item_name" value="Ayam masak kicap">
            <input type="hidden" name="item_price" value="4.OO">
            <!-- Input field for quantity -->
            <input type="number" name="quantity" value="1">
            <input type="hidden" name="item_image" value="m6.png">

            <!-- Submit button to add item to cart -->
            <button type="submit" class="add-to-cart-btn" name="add_to_cart">Add to Cart</button>
        </form>
    </div>
</div>


        
<div class="menu-item-3">
    <img src="m7.png" alt="Food Image 2">
    <div class="menu-food">
        <h3>Crab finger</h3>
        <p>RM:3.OO</p>
        <!-- Form for adding items to the cart -->
        <form class="add-to-cart-form-food" method="POST">
            <!-- Hidden input fields for item name and price -->
            <input type="hidden" name="item_name" value="Crab finger">
            <input type="hidden" name="item_price" value="3.OO">
            <!-- Input field for quantity -->
            <input type="number" name="quantity" value="1">
            <input type="hidden" name="item_image" value="m7.png">

            <!-- Submit button to add item to cart -->
            <button type="submit" class="add-to-cart-btn" name="add_to_cart">Add to Cart</button>
        </form>
    </div>
</div>
        
               
<div class="menu-item-3">
    <img src="m8.png" alt="Food Image 2">
    <div class="menu-food">
        <h3>Meatball blackpaper</h3>
        <p>RM:2.OO</p>
        <!-- Form for adding items to the cart -->
        <form class="add-to-cart-form-food" method="POST">
            <!-- Hidden input fields for item name and price -->
            <input type="hidden" name="item_name" value="Meatball blackpaper">
            <input type="hidden" name="item_price" value="2.OO">
            <!-- Input field for quantity -->
            <input type="number" name="quantity" value="1">
            <input type="hidden" name="item_image" value="m8.png">

            <!-- Submit button to add item to cart -->
            <button type="submit" class="add-to-cart-btn" name="add_to_cart">Add to Cart</button>
        </form>
    </div>
</div>
        
        
<div class="menu-item-3">
    <img src="m9.png" alt="Food Image 2">
    <div class="menu-food">
        <h3>Nugget ikan</h3>
        <p>RM:2.OO</p>
        <!-- Form for adding items to the cart -->
        <form class="add-to-cart-form-food" method="POST">
            <input type="hidden" name="item_name" value="Nugget ikan">
            <input type="hidden" name="item_price" value="2.OO">
            <!-- Input field for quantity -->
            <input type="number" name="quantity" value="1">
            <input type="hidden" name="item_image" value="m9.png">

            <!-- Submit button to add item to cart -->
            <button type="submit" class="add-to-cart-btn" name="add_to_cart">Add to Cart</button>
        </form>
    </div>
</div>
        



<div class="menu-item-3">
    <img src="m10.png" alt="Food Image 2">
    <div class="menu-food">
        <h3>Nugget</h3>
        <p>RM:2.OO</p>
        <!-- Form for adding items to the cart -->
        <form class="add-to-cart-form-food" method="POST">
            <!-- Hidden input fields for item name and price -->
            <input type="hidden" name="item_name" value="Nugget">
            <input type="hidden" name="item_price" value="2.OO">
            <!-- Input field for quantity -->
            <input type="number" name="quantity" value="1">
            <input type="hidden" name="item_image" value="m10.png">

            <!-- Submit button to add item to cart -->
            <button type="submit" class="add-to-cart-btn" name="add_to_cart">Add to Cart</button>
        </form>
    </div>
</div>
        




<div class="menu-item-3">
    <img src="m11.png" alt="Food Image 2">
    <div class="menu-food">
        <h3>Sosej</h3>
        <p>RM:2.OO</p>
        <!-- Form for adding items to the cart -->
        <form class="add-to-cart-form-food" method="POST">
            <!-- Hidden input fields for item name and price -->
            <input type="hidden" name="item_name" value="Sosej">
            <input type="hidden" name="item_price" value="2.OO">
            <!-- Input field for quantity -->
            <input type="number" name="quantity" value="1">
            <input type="hidden" name="item_image" value="m11.png">

            <!-- Submit button to add item to cart -->
            <button type="submit" class="add-to-cart-btn" name="add_to_cart">Add to Cart</button>
        </form>
    </div>
</div>
        




<div class="menu-item-3">
    <img src="m12.png" alt="Food Image 2">
    <div class="menu-food">
        <h3>Telur goreng</h3>
        <p>RM:2.OO</p>
        <!-- Form for adding items to the cart -->
        <form class="add-to-cart-form-food" method="POST">
            <!-- Hidden input fields for item name and price -->
            <input type="hidden" name="item_name" value="Telur goreng">
            <input type="hidden" name="item_price" value="2.OO">
            <!-- Input field for quantity -->
            <input type="number" name="quantity" value="1">
            <input type="hidden" name="item_image" value="m11.png">

            <!-- Submit button to add item to cart -->
            <button type="submit" class="add-to-cart-btn" name="add_to_cart">Add to Cart</button>
        </form>
    </div>
</div>

<div class="menu-item-3">
    <img src="m13.png" alt="Food Image 2">
    <div class="menu-food">
        <h3>Telur sambal</h3>
        <p>RM:2.OO</p>
        <!-- Form for adding items to the cart -->
        <form class="add-to-cart-form-food" method="POST">
            <!-- Hidden input fields for item name and price -->
            <input type="hidden" name="item_name" value="Telur sambal">
            <input type="hidden" name="item_price" value="2.OO">
            <!-- Input field for quantity -->
            <input type="number" name="quantity" value="1">
            <input type="hidden" name="item_image" value="m13.png">

            <!-- Submit button to add item to cart -->
            <button type="submit" class="add-to-cart-btn" name="add_to_cart">Add to Cart</button>
        </form>
    </div>
</div>




<div class="menu-item-3">
    <img src="m14.png" alt="Food Image 2">
    <div class="menu-food">
        <h3>Ulam ulaman</h3>
        <p>RM:1.OO</p>
        <!-- Form for adding items to the cart -->
        <form class="add-to-cart-form-food" method="POST">
    <!-- Hidden input fields for item details -->
    <input type="hidden" name="item_name" value="Ulam ulaman">
    <input type="hidden" name="item_price" value="1.00">
    <!-- Input field for quantity -->
    <input type="number" name="quantity" value="1">
    <input type="hidden" name="item_image" value="m14.png">

    <!-- Submit button to add item to cart -->
    <button type="submit" class="add-to-cart-btn" name="add_to_cart">Add to Cart</button>
</form>
    </div>
</div>

<div class="menu-item-3">
    <img src="m15.png" alt="Food Image 2">
    <div class="menu-food">
        <h3>Telur masin</h3>
        <p>RM:2.00</p>
        <!-- Form for adding items to the cart -->
      <!-- Form for adding food items to the cart -->
<form class="add-to-cart-form-food" method="POST">
    <!-- Hidden input fields for item details -->
    <input type="hidden" name="item_name" value="Telur masin">
    <input type="hidden" name="item_price" value="2.00">
    <!-- Input field for quantity -->
    <input type="number" name="quantity" value="1">
    <input type="hidden" name="item_image" value="m15.png">

    <!-- Submit button to add item to cart -->
    <button type="submit" class="add-to-cart-btn" name="add_to_cart">Add to Cart</button>
</form>

    </div>
</div>


      
    </section>


        <section id="drink" class="content-section">
            <h2>Minuman Information</h2>
            <p>Welcome to our booking page. Please select a menu image and click "Confirm" to fill out the booking details:</p>



 <div class="menu-item-3">
        <img src="n1.png" alt="Drink Image 1">
        <div class="menu-drink">
        <h3>Extra jos</h3>
        <p>RM:2.50</p>
        <!-- Form for adding items to the cart -->
     <!-- Form for adding drink items to the cart -->
        <form class="add-to-cart-form-drink" method="POST">
           <!-- Hidden input fields for item details -->
           <input type="hidden" name="item_name" value="Extra jos">
           <input type="hidden" name="item_price" value="2.50">
           <input type="hidden" name="item_image" value="n1.png">
           <!-- Input field for quantity -->
           <input type="number" name="quantity" value="1">
          <!-- Submit button to add item to cart -->
          <button type="submit" class="add-to-cart-btn" name="add_to_cart">Add to Cart</button>
      </form>

    </div>
</div>


<div class="menu-item-3">
        <img src="n2.png" alt="Drink Image 2">
        <div class="menu-drink">
        <h3>Kopi ais</h3>
        <p>RM:2.50</p>
        <!-- Form for adding items to the cart -->
     <!-- Form for adding drink items to the cart -->
        <form class="add-to-cart-form-drink" method="POST">
           <!-- Hidden input fields for item details -->
           <input type="hidden" name="item_name" value="Kopi ais">
           <input type="hidden" name="item_price" value="2.50">
           <input type="hidden" name="item_image" value="n2.png">
           <!-- Input field for quantity -->
           <input type="number" name="quantity" value="1">
          <!-- Submit button to add item to cart -->
          <button type="submit" class="add-to-cart-btn" name="add_to_cart">Add to Cart</button>
      </form>

    </div>
</div>


<div class="menu-item-3">
        <img src="n3.png" alt="Drink Image 3">
        <div class="menu-drink">
        <h3>Kopi O</h3>
        <p>RM:1.00</p>
        <!-- Form for adding items to the cart -->
     <!-- Form for adding drink items to the cart -->
        <form class="add-to-cart-form-drink" method="POST">
           <!-- Hidden input fields for item details -->
           <input type="hidden" name="item_name" value="Kopi O">
           <input type="hidden" name="item_price" value="1.00">
           <input type="hidden" name="item_image" value="n1.png">
           <!-- Input field for quantity -->
           <input type="number" name="quantity" value="1">
          <!-- Submit button to add item to cart -->
          <button type="submit" class="add-to-cart-btn" name="add_to_cart">Add to Cart</button>
      </form>

    </div>
</div>



            
<div class="menu-item-3">
        <img src="n4.png" alt="Drink Image 4">
        <div class="menu-drink">
        <h3>Kopi Panas</h3>
        <p>RM:2.00</p>
        <!-- Form for adding items to the cart -->
     <!-- Form for adding drink items to the cart -->
        <form class="add-to-cart-form-drink" method="POST">
           <!-- Hidden input fields for item details -->
           <input type="hidden" name="item_name" value="Kopi O">
           <input type="hidden" name="item_price" value="1.00">
           <input type="hidden" name="item_image" value="n4.png">
           <!-- Input field for quantity -->
           <input type="number" name="quantity" value="1">
          <!-- Submit button to add item to cart -->
          <button type="submit" class="add-to-cart-btn" name="add_to_cart">Add to Cart</button>
      </form>

    </div>
</div>


            
<div class="menu-item-3">
        <img src="n5.png" alt="Drink Image 5">
        <div class="menu-drink">
        <h3>Limau Ais</h3>
        <p>RM:2.00</p>
        <!-- Form for adding items to the cart -->
     <!-- Form for adding drink items to the cart -->
        <form class="add-to-cart-form-drink" method="POST">
           <!-- Hidden input fields for item details -->
           <input type="hidden" name="item_name" value="Limau Ais">
           <input type="hidden" name="item_price" value="2.00">
           <input type="hidden" name="item_image" value="n5.png">
           <!-- Input field for quantity -->
           <input type="number" name="quantity" value="1">
          <!-- Submit button to add item to cart -->
          <button type="submit" class="add-to-cart-btn" name="add_to_cart">Add to Cart</button>
      </form>

    </div>
</div>



            
<div class="menu-item-3">
        <img src="n6.png" alt="Drink Image 5">
        <div class="menu-drink">
        <h3>Limau Panas</h3>
        <p>RM:2.00</p>
        <!-- Form for adding items to the cart -->
     <!-- Form for adding drink items to the cart -->
        <form class="add-to-cart-form-drink" method="POST">
           <!-- Hidden input fields for item details -->
           <input type="hidden" name="item_name" value="Limau Panas">
           <input type="hidden" name="item_price" value="2.00">
           <input type="hidden" name="item_image" value="n6.png">
           <!-- Input field for quantity -->
           <input type="number" name="quantity" value="1">
          <!-- Submit button to add item to cart -->
          <button type="submit" class="add-to-cart-btn" name="add_to_cart">Add to Cart</button>
      </form>

    </div>
</div>


<div class="menu-item-3">
        <img src="n7.png" alt="Drink Image 5">
        <div class="menu-drink">
        <h3>Milo Ais</h3>
        <p>RM:2.50</p>
        <!-- Form for adding items to the cart -->
     <!-- Form for adding drink items to the cart -->
        <form class="add-to-cart-form-drink" method="POST">
           <!-- Hidden input fields for item details -->
           <input type="hidden" name="item_name" value="Milo Ais">
           <input type="hidden" name="item_price" value="2.50">
           <input type="hidden" name="item_image" value="n7.png">
           <!-- Input field for quantity -->
           <input type="number" name="quantity" value="1">
          <!-- Submit button to add item to cart -->
          <button type="submit" class="add-to-cart-btn" name="add_to_cart">Add to Cart</button>
      </form>

    </div>
</div>





<div class="menu-item-3">
        <img src="n8.png" alt="Drink Image 5">
        <div class="menu-drink">
        <h3>Milo Panas</h3>
        <p>RM:2.00</p>
        <!-- Form for adding items to the cart -->
     <!-- Form for adding drink items to the cart -->
        <form class="add-to-cart-form-drink" method="POST">
           <!-- Hidden input fields for item details -->
           <input type="hidden" name="item_name" value="Milo Panas">
           <input type="hidden" name="item_price" value="2.00">
           <input type="hidden" name="item_image" value="n8.png">
           <!-- Input field for quantity -->
           <input type="number" name="quantity" value="1">
          <!-- Submit button to add item to cart -->
          <button type="submit" class="add-to-cart-btn" name="add_to_cart">Add to Cart</button>
      </form>

    </div>
</div>



            
<div class="menu-item-3">
        <img src="n9.png" alt="Drink Image 5">
        <div class="menu-drink">
        <h3>Nes O Panas</h3>
        <p>RM:1.00</p>
        <!-- Form for adding items to the cart -->
     <!-- Form for adding drink items to the cart -->
        <form class="add-to-cart-form-drink" method="POST">
           <!-- Hidden input fields for item details -->
           <input type="hidden" name="item_name" value="Nes O Panas">
           <input type="hidden" name="item_price" value="1.00">
           <input type="hidden" name="item_image" value="n9.png">
           <!-- Input field for quantity -->
           <input type="number" name="quantity" value="1">
          <!-- Submit button to add item to cart -->
          <button type="submit" class="add-to-cart-btn" name="add_to_cart">Add to Cart</button>
      </form>

    </div>
</div>




            
<div class="menu-item-3">
        <img src="n10.png" alt="Drink Image 5">
        <div class="menu-drink">
        <h3>Nes Panas</h3>
        <p>RM:2.00</p>
        <!-- Form for adding items to the cart -->
     <!-- Form for adding drink items to the cart -->
        <form class="add-to-cart-form-drink" method="POST">
           <!-- Hidden input fields for item details -->
           <input type="hidden" name="item_name" value="Nes Panas">
           <input type="hidden" name="item_price" value="2.00">
           <input type="hidden" name="item_image" value="n10.png">
           <!-- Input field for quantity -->
           <input type="number" name="quantity" value="1">
          <!-- Submit button to add item to cart -->
          <button type="submit" class="add-to-cart-btn" name="add_to_cart">Add to Cart</button>
      </form>

    </div>
</div>




<div class="menu-item-3">
        <img src="n11.png" alt="Drink Image 5">
        <div class="menu-drink">
        <h3>Neslo Ais</h3>
        <p>RM:3.00</p>
        <!-- Form for adding items to the cart -->
     <!-- Form for adding drink items to the cart -->
        <form class="add-to-cart-form-drink" method="POST">
           <!-- Hidden input fields for item details -->
           <input type="hidden" name="item_name" value="Neslo Ais">
           <input type="hidden" name="item_price" value="3.00">
           <input type="hidden" name="item_image" value="n11.png">
           <!-- Input field for quantity -->
           <input type="number" name="quantity" value="1">
          <!-- Submit button to add item to cart -->
          <button type="submit" class="add-to-cart-btn" name="add_to_cart">Add to Cart</button>
      </form>

    </div>
</div>




<div class="menu-item-3">
        <img src="n12.png" alt="Drink Image 12">
        <div class="menu-drink">
        <h3>Teh Ais</h3>
        <p>RM:2.00</p>
        <!-- Form for adding items to the cart -->
     <!-- Form for adding drink items to the cart -->
        <form class="add-to-cart-form-drink" method="POST">
           <!-- Hidden input fields for item details -->
           <input type="hidden" name="item_name" value="Teh Ais">
           <input type="hidden" name="item_price" value="2.00">
           <input type="hidden" name="item_image" value="n12.png">
           <!-- Input field for quantity -->
           <input type="number" name="quantity" value="1">
          <!-- Submit button to add item to cart -->
          <button type="submit" class="add-to-cart-btn" name="add_to_cart">Add to Cart</button>
      </form>

    </div>
</div>

                     




<div class="menu-item-3">
        <img src="n13.png" alt="Drink Image 13">
        <div class="menu-drink">
        <h3>Teh O Panas</h3>
        <p>RM:1.50</p>
        <!-- Form for adding items to the cart -->
     <!-- Form for adding drink items to the cart -->
        <form class="add-to-cart-form-drink" method="POST">
           <!-- Hidden input fields for item details -->
           <input type="hidden" name="item_name" value="Teh O Panas">
           <input type="hidden" name="item_price" value="2.50">
           <input type="hidden" name="item_image" value="n13.png">
           <!-- Input field for quantity -->
           <input type="number" name="quantity" value="1">
          <!-- Submit button to add item to cart -->
          <button type="submit" class="add-to-cart-btn" name="add_to_cart">Add to Cart</button>
      </form>

    </div>
</div>






<div class="menu-item-3">
        <img src="n14.png" alt="Drink Image 13">
        <div class="menu-drink">
        <h3>Teh O Ais</h3>
        <p>RM:1.50</p>
        <!-- Form for adding items to the cart -->
     <!-- Form for adding drink items to the cart -->
        <form class="add-to-cart-form-drink" method="POST">
           <!-- Hidden input fields for item details -->
           <input type="hidden" name="item_name" value="Teh O Ais">
           <input type="hidden" name="item_price" value="1.50">
           <input type="hidden" name="item_image" value="n14.png">
           <!-- Input field for quantity -->
           <input type="number" name="quantity" value="1">
          <!-- Submit button to add item to cart -->
          <button type="submit" class="add-to-cart-btn" name="add_to_cart">Add to Cart</button>
      </form>

    </div>
</div>




<div class="menu-item-3">
        <img src="n15.png" alt="Drink Image 13">
        <div class="menu-drink">
        <h3>Teh O Limau Ais</h3>
        <p>RM:2.00</p>
        <!-- Form for adding items to the cart -->
     <!-- Form for adding drink items to the cart -->
        <form class="add-to-cart-form-drink" method="POST">
           <!-- Hidden input fields for item details -->
           <input type="hidden" name="item_name" value="Teh O Limau Ais">
           <input type="hidden" name="item_price" value="2.00">
           <input type="hidden" name="item_image" value="n15.png">
           <!-- Input field for quantity -->
           <input type="number" name="quantity" value="1">
          <!-- Submit button to add item to cart -->
          <button type="submit" class="add-to-cart-btn" name="add_to_cart">Add to Cart</button>
      </form>

    </div>
</div>
 
            


            <div class="popup-modal" id="popup-drink">
                <div class="popup-content">
                    <span class="close-btn" onclick="closePopupDrink()">&times;</span>
                    <p>Your drink has been added to the cart!</p>
                </div>
            </div>
                           
        </section>

        

    <!-- Popup for successful addition to cart -->
    <div id="success-popup" class="popup-modal" style="display: none;">
    <div class="popup-content">
        <span class="close-btn" onclick="closePopup()">&times;</span>
        <p>Item added to cart successfully!</p>
    </div>
</div>

<script>
    // Function to handle form submission and show success popup
    function handleFormSubmission(form) {
        // Retrieve the form data
        var formData = new FormData(form);

        // Send an AJAX request to the server
        var xhr = new XMLHttpRequest();
        xhr.open('POST', '<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>', true);
        xhr.onload = function () {
            if (xhr.status === 200) {
                // Show the success popup
                showSuccessPopup();
            }
        };
        xhr.send(formData);
    }

    // Function to show the success popup
    function showSuccessPopup() {
        var successPopup = document.getElementById('success-popup');
        successPopup.style.display = 'block';
        // Hide the popup after 2 seconds
        setTimeout(function() {
            successPopup.style.display = 'none';
        }, 2000);
    }

    // Attach event listeners to forms from food and drink menus
    document.querySelectorAll('.add-to-cart-form-food, .add-to-cart-form-drink').forEach(function(form) {
        form.addEventListener('submit', function(event) {
            // Prevent the default form submission behavior
            event.preventDefault();
            // Handle form submission
            handleFormSubmission(form);
        });
    });
</script>

    
<section id="cart" class="content-section">
    <h2>Shopping Cart</h2>
    <div id="cart-items" class="cart-items">
        <!-- Cart items will be dynamically loaded here -->
    </div>
    <!-- Checkout Button -->
    <a href="#" onclick="showContent('checkout')" class="checkout-button">Checkout</a>
</section>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
    $(document).ready(function() {
        // Function to fetch cart items and update the cart
        function updateCart() {
            $.ajax({
                url: 'fetch_cart_items.php', // Adjust the URL to your PHP script
                type: 'GET',
                dataType: 'html',
                success: function(response) {
                    // Update the cart items
                    $('#cart-items').html(response);
                },
                error: function(xhr, status, error) {
                    console.error(xhr.responseText);
                }
            });
        }

        // Update cart initially
        updateCart();

        // Set interval to periodically update the cart
        setInterval(updateCart, 5000); // Update every 5 seconds (5000 milliseconds)
    });
</script>

<section id="checkout" class="content-section">
    <h2>Checkout</h2>

    <div class="cart-items">   

  
        <?php
        // Include the database configuration file
        include 'config.php';

        // Retrieve cart items from the database
        $sql = "SELECT item_name, item_price, quantity, item_image, time_added FROM cart";
        $result = $conn->query($sql);

        // Initialize total price variable
        $totalPrice = 0;

        // Check if there are items in the cart
        if ($result->num_rows > 0) {
            // Display cart items
            while ($row = $result->fetch_assoc()) {
                // Calculate subtotal for each item
                $subtotal = $row['item_price'] * $row['quantity'];
                $totalPrice += $subtotal; // Add subtotal to total price
                ?>
                <div class="cart-item">
                    <div class="item-image">
                        <img src="<?php echo $row['item_image']; ?>" alt="Item Image">
                    </div>
                    <div class="item-details">
                        <p>Name: <?php echo $row['item_name']; ?></p>
                        <p>Price: <?php echo $row['item_price']; ?></p>
                        <p>Quantity: <?php echo $row['quantity']; ?></p>
                        <p>Added Time: <?php echo $row['time_added']; ?></p>
                        <p>Subtotal: <?php echo $subtotal; ?></p>
                    </div>
                </div>
                <?php
            }
            // Display total price after all items are listed
            echo "<p>Total Price: $totalPrice</p>";
        } else {
            // If cart is empty
            echo "<p>Your cart is empty.</p>";
        }
        ?>
    </div>

    <!-- Payment Method Selection -->
    <div class="payment-method">
        <h3>Payment Method</h3>
        <p>Select your preferred payment method:</p>
        <select id="paymentMethod" onchange="handlePaymentMethod()">
            <option value="cash">Cash</option> <!-- Option for Cash -->
            <option value="qr_code">QR Code</option> <!-- Option for QR Code -->
        </select>

        <!-- QR Code Image -->
        <div id="qrCode" style="display: none;">
            <!-- Insert your QR code image here -->
            <img src="path_to_your_qr_code_image" alt="QR Code">
            <!-- Button to Scan QR Code -->
            <button onclick="scanQRCode()">Scan QR Code</button>
        </div>

        <!-- Proceed to Payment Button (Submit the Form) -->
        <button onclick="proceedToPayment()">Proceed to Payment</button>
    </div>


</section>

<script>
    function proceedToPayment() {
        // Submit the form
        document.getElementById("userDetailsForm").submit();
    }

    function scanQRCode() {
        // Assuming you have a library or method to handle QR code scanning
        // For example, you might use a third-party library like QuaggaJS
        
        // Open the device's camera for scanning
        // You would need to implement this part using the appropriate methods from your chosen library
        alert("Please use your device's camera to scan the QR code.");
        // Here you can call the scanning function from your chosen library
    }
</script>


<script>
    function scanQRCode() {
        // Assuming you have a library or method to handle QR code scanning
        // For example, you might use a third-party library like QuaggaJS
        
        // Open the device's camera for scanning
        // You would need to implement this part using the appropriate methods from your chosen library
        alert("Please use your device's camera to scan the QR code.");
        // Here you can call the scanning function from your chosen library
    }

    // Handle form submission
    document.getElementById("userDetailsForm").addEventListener("submit", function(event) {
        // Prevent default form submission
        event.preventDefault();
        
        // Get form data
        var formData = new FormData(this);
        
        // Perform AJAX submission or further processing as needed
        // For example, you can use fetch API to send form data to server
        fetch('submit_user_details.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.text())
        .then(data => { 
            // Handle response here if needed
            console.log(data);
        })
        .catch(error => {
            console.error('Error:', error);
        });
    });
</script>
















        <section id="place" class="content-section">
            <h2>place order</h2>
            <div id="checkoutItems"></div>
            <div id="checkoutTotal"></div>
            <div id="userDetails" class="user-details">
                <div id="userDetailsCheckout" class="user-details">
                    <!-- User details will be displayed here -->
                </div>

            </div>
        </section>


       

        
        
     

        
    </div>

    <footer class="footer-1">
        <div class="container-bawah">

            <div class="footer-columns">

                <div class="column-bawah">
                    <h3>Adress</h3>
                    <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3986.2687536345197!2d103.82626790987003!3d2.417023897551915!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x31c54ba2b505ec67%3A0xf1f388f33ecdec72!2sPoliteknik%20Mersing%2C%20Johor!5e0!3m2!1sms!2smy!4v1708052654629!5m2!1sms!2smy" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>                        <p class="address">POLITEKNIK MERSING JOHOR</p>
                </div>
                
                <div class="column-bawah" style="font-size: 16px; color: #ffff; line-height: 1.5; font-family: Arial, sans-serif;">
    We provide a simple application that makes it easier for you as a customer to continue enjoying your meal more comfortably.
</div>

                
                <div class="column-bawah">
                    <h3>Why Choose Us</h3>
                    <p>Choosing us means choosing excellence. Here are a few reasons why we stand out:</p>
                    
                    <p>But don't just take our word for it! Hear what our satisfied customers have to say:</p>
                    <blockquote>
                        "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua." - John Doe
                    </blockquote>
                </div>
                
            </div>
        </div>
    </footer>

    
    <script>
        function showContent(sectionId) {
            var contentSections = document.getElementsByClassName('content-section');
    
            for (var i = 0; i < contentSections.length; i++) {
                contentSections[i].style.display = 'none';
            }
    
            var selectedSection = document.getElementById(sectionId);
    
            if (selectedSection) {
                selectedSection.style.display = 'block';
                // Store the current section in local storage
                storeCurrentSection(sectionId);
            }
        }
    
        function showHomeSection() {
            showContent('home');
        }
    
        function storeCurrentSection(sectionId) {
            localStorage.setItem('currentSection', sectionId);
        }
    
        window.onload = function() {
            // Retrieve the current section from local storage
            var currentSection = localStorage.getItem('currentSection');
            
            // If there is a current section stored, show it
            if (currentSection) {
                showContent(currentSection);
            } else {
                // Otherwise, show the default section (e.g., "Home")
                showHomeSection();
            }
        };




        
    </script>



    

    
    
    


    
</body>


</html>
